<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xProduct30 StructType
 * @subpackage Structs
 */
class XProduct30 extends XObject30
{
    /**
     * The uniqueId
     * @var string
     */
    public $uniqueId;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The brandName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $brandName;
    /**
     * The brandId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $brandId;
    /**
     * The material
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $material;
    /**
     * The colorCode
     * @var string
     */
    public $colorCode;
    /**
     * The colorDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $colorDesc;
    /**
     * The seasonCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $seasonCode;
    /**
     * The seasonDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $seasonDesc;
    /**
     * The categoryCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $categoryCode;
    /**
     * The categoryDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $categoryDesc;
    /**
     * The collectionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $collectionId;
    /**
     * The collectionDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $collectionDesc;
    /**
     * The minimalOrderQuantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $minimalOrderQuantity;
    /**
     * The minimumQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XMinimumQuantity30[]
     */
    public $minimumQuantity;
    /**
     * The deliveryStartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deliveryStartDate;
    /**
     * The deliveryEndDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deliveryEndDate;
    /**
     * The firstReceiptDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstReceiptDate;
    /**
     * The productGroupCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productGroupCode;
    /**
     * The productGroupDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productGroupDesc;
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XPrice30[]
     */
    public $price;
    /**
     * The size
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XSize30[]
     */
    public $size;
    /**
     * The sale
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sale;
    /**
     * The saleBackgroundColor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $saleBackgroundColor;
    /**
     * The noos
     * @var bool
     */
    public $noos;
    /**
     * The medium
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XMedium30[]
     */
    public $medium;
    /**
     * The crossReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $crossReference;
    /**
     * The extraField
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XExtraField30[]
     */
    public $extraField;
    /**
     * The searchText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchText;
    /**
     * The deliverySubBlock
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $deliverySubBlock;
    /**
     * The deliveryWindow
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XDeliveryWindow30[]
     */
    public $deliveryWindow;
    /**
     * The gender
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gender;
    /**
     * The sortCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sortCode;
    /**
     * The userDefinedField1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userDefinedField1;
    /**
     * The userDefinedField2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userDefinedField2;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The summary
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $summary;
    /**
     * The fit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fit;
    /**
     * The marginGroupCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $marginGroupCode;
    /**
     * The discountGroupCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $discountGroupCode;
    /**
     * The styleAttributes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $styleAttributes;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The sizeIndependentStockLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XStockLevel30[]
     */
    public $sizeIndependentStockLevel;
    /**
     * Constructor method for xProduct30
     * @uses XProduct30::setUniqueId()
     * @uses XProduct30::setName()
     * @uses XProduct30::setDescription()
     * @uses XProduct30::setBrandName()
     * @uses XProduct30::setBrandId()
     * @uses XProduct30::setMaterial()
     * @uses XProduct30::setColorCode()
     * @uses XProduct30::setColorDesc()
     * @uses XProduct30::setSeasonCode()
     * @uses XProduct30::setSeasonDesc()
     * @uses XProduct30::setCategoryCode()
     * @uses XProduct30::setCategoryDesc()
     * @uses XProduct30::setCollectionId()
     * @uses XProduct30::setCollectionDesc()
     * @uses XProduct30::setMinimalOrderQuantity()
     * @uses XProduct30::setMinimumQuantity()
     * @uses XProduct30::setDeliveryStartDate()
     * @uses XProduct30::setDeliveryEndDate()
     * @uses XProduct30::setFirstReceiptDate()
     * @uses XProduct30::setProductGroupCode()
     * @uses XProduct30::setProductGroupDesc()
     * @uses XProduct30::setPrice()
     * @uses XProduct30::setSize()
     * @uses XProduct30::setSale()
     * @uses XProduct30::setSaleBackgroundColor()
     * @uses XProduct30::setNoos()
     * @uses XProduct30::setMedium()
     * @uses XProduct30::setCrossReference()
     * @uses XProduct30::setExtraField()
     * @uses XProduct30::setSearchText()
     * @uses XProduct30::setDeliverySubBlock()
     * @uses XProduct30::setDeliveryWindow()
     * @uses XProduct30::setGender()
     * @uses XProduct30::setSortCode()
     * @uses XProduct30::setUserDefinedField1()
     * @uses XProduct30::setUserDefinedField2()
     * @uses XProduct30::setStatus()
     * @uses XProduct30::setSummary()
     * @uses XProduct30::setFit()
     * @uses XProduct30::setMarginGroupCode()
     * @uses XProduct30::setDiscountGroupCode()
     * @uses XProduct30::setStyleAttributes()
     * @uses XProduct30::setStartDate()
     * @uses XProduct30::setEndDate()
     * @uses XProduct30::setSizeIndependentStockLevel()
     * @param string $uniqueId
     * @param string $name
     * @param string $description
     * @param string $brandName
     * @param string $brandId
     * @param string $material
     * @param string $colorCode
     * @param string $colorDesc
     * @param string $seasonCode
     * @param string $seasonDesc
     * @param string $categoryCode
     * @param string $categoryDesc
     * @param string $collectionId
     * @param string $collectionDesc
     * @param int $minimalOrderQuantity
     * @param \ApptitudeNamespace\StructType\XMinimumQuantity30[] $minimumQuantity
     * @param string $deliveryStartDate
     * @param string $deliveryEndDate
     * @param string $firstReceiptDate
     * @param string $productGroupCode
     * @param string $productGroupDesc
     * @param \ApptitudeNamespace\StructType\XPrice30[] $price
     * @param \ApptitudeNamespace\StructType\XSize30[] $size
     * @param string $sale
     * @param string $saleBackgroundColor
     * @param bool $noos
     * @param \ApptitudeNamespace\StructType\XMedium30[] $medium
     * @param string $crossReference
     * @param \ApptitudeNamespace\StructType\XExtraField30[] $extraField
     * @param string $searchText
     * @param string[] $deliverySubBlock
     * @param \ApptitudeNamespace\StructType\XDeliveryWindow30[] $deliveryWindow
     * @param string $gender
     * @param int $sortCode
     * @param string $userDefinedField1
     * @param string $userDefinedField2
     * @param string $status
     * @param string $summary
     * @param string $fit
     * @param string $marginGroupCode
     * @param string $discountGroupCode
     * @param string $styleAttributes
     * @param string $startDate
     * @param string $endDate
     * @param \ApptitudeNamespace\StructType\XStockLevel30[] $sizeIndependentStockLevel
     */
    public function __construct($uniqueId = null, $name = null, $description = null, $brandName = null, $brandId = null, $material = null, $colorCode = null, $colorDesc = null, $seasonCode = null, $seasonDesc = null, $categoryCode = null, $categoryDesc = null, $collectionId = null, $collectionDesc = null, $minimalOrderQuantity = null, array $minimumQuantity = array(), $deliveryStartDate = null, $deliveryEndDate = null, $firstReceiptDate = null, $productGroupCode = null, $productGroupDesc = null, array $price = array(), array $size = array(), $sale = null, $saleBackgroundColor = null, $noos = null, array $medium = array(), $crossReference = null, array $extraField = array(), $searchText = null, array $deliverySubBlock = array(), array $deliveryWindow = array(), $gender = null, $sortCode = null, $userDefinedField1 = null, $userDefinedField2 = null, $status = null, $summary = null, $fit = null, $marginGroupCode = null, $discountGroupCode = null, $styleAttributes = null, $startDate = null, $endDate = null, array $sizeIndependentStockLevel = array())
    {
        $this
            ->setUniqueId($uniqueId)
            ->setName($name)
            ->setDescription($description)
            ->setBrandName($brandName)
            ->setBrandId($brandId)
            ->setMaterial($material)
            ->setColorCode($colorCode)
            ->setColorDesc($colorDesc)
            ->setSeasonCode($seasonCode)
            ->setSeasonDesc($seasonDesc)
            ->setCategoryCode($categoryCode)
            ->setCategoryDesc($categoryDesc)
            ->setCollectionId($collectionId)
            ->setCollectionDesc($collectionDesc)
            ->setMinimalOrderQuantity($minimalOrderQuantity)
            ->setMinimumQuantity($minimumQuantity)
            ->setDeliveryStartDate($deliveryStartDate)
            ->setDeliveryEndDate($deliveryEndDate)
            ->setFirstReceiptDate($firstReceiptDate)
            ->setProductGroupCode($productGroupCode)
            ->setProductGroupDesc($productGroupDesc)
            ->setPrice($price)
            ->setSize($size)
            ->setSale($sale)
            ->setSaleBackgroundColor($saleBackgroundColor)
            ->setNoos($noos)
            ->setMedium($medium)
            ->setCrossReference($crossReference)
            ->setExtraField($extraField)
            ->setSearchText($searchText)
            ->setDeliverySubBlock($deliverySubBlock)
            ->setDeliveryWindow($deliveryWindow)
            ->setGender($gender)
            ->setSortCode($sortCode)
            ->setUserDefinedField1($userDefinedField1)
            ->setUserDefinedField2($userDefinedField2)
            ->setStatus($status)
            ->setSummary($summary)
            ->setFit($fit)
            ->setMarginGroupCode($marginGroupCode)
            ->setDiscountGroupCode($discountGroupCode)
            ->setStyleAttributes($styleAttributes)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setSizeIndependentStockLevel($sizeIndependentStockLevel);
    }
    /**
     * Get uniqueId value
     * @return string|null
     */
    public function getUniqueId()
    {
        return $this->uniqueId;
    }
    /**
     * Set uniqueId value
     * @param string $uniqueId
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setUniqueId($uniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueId) && !is_string($uniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uniqueId)), __LINE__);
        }
        $this->uniqueId = $uniqueId;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get brandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->brandName;
    }
    /**
     * Set brandName value
     * @param string $brandName
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setBrandName($brandName = null)
    {
        // validation for constraint: string
        if (!is_null($brandName) && !is_string($brandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brandName)), __LINE__);
        }
        $this->brandName = $brandName;
        return $this;
    }
    /**
     * Get brandId value
     * @return string|null
     */
    public function getBrandId()
    {
        return $this->brandId;
    }
    /**
     * Set brandId value
     * @param string $brandId
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setBrandId($brandId = null)
    {
        // validation for constraint: string
        if (!is_null($brandId) && !is_string($brandId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brandId)), __LINE__);
        }
        $this->brandId = $brandId;
        return $this;
    }
    /**
     * Get material value
     * @return string|null
     */
    public function getMaterial()
    {
        return $this->material;
    }
    /**
     * Set material value
     * @param string $material
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setMaterial($material = null)
    {
        // validation for constraint: string
        if (!is_null($material) && !is_string($material)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($material)), __LINE__);
        }
        $this->material = $material;
        return $this;
    }
    /**
     * Get colorCode value
     * @return string|null
     */
    public function getColorCode()
    {
        return $this->colorCode;
    }
    /**
     * Set colorCode value
     * @param string $colorCode
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setColorCode($colorCode = null)
    {
        // validation for constraint: string
        if (!is_null($colorCode) && !is_string($colorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($colorCode)), __LINE__);
        }
        $this->colorCode = $colorCode;
        return $this;
    }
    /**
     * Get colorDesc value
     * @return string|null
     */
    public function getColorDesc()
    {
        return $this->colorDesc;
    }
    /**
     * Set colorDesc value
     * @param string $colorDesc
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setColorDesc($colorDesc = null)
    {
        // validation for constraint: string
        if (!is_null($colorDesc) && !is_string($colorDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($colorDesc)), __LINE__);
        }
        $this->colorDesc = $colorDesc;
        return $this;
    }
    /**
     * Get seasonCode value
     * @return string|null
     */
    public function getSeasonCode()
    {
        return $this->seasonCode;
    }
    /**
     * Set seasonCode value
     * @param string $seasonCode
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setSeasonCode($seasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($seasonCode) && !is_string($seasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seasonCode)), __LINE__);
        }
        $this->seasonCode = $seasonCode;
        return $this;
    }
    /**
     * Get seasonDesc value
     * @return string|null
     */
    public function getSeasonDesc()
    {
        return $this->seasonDesc;
    }
    /**
     * Set seasonDesc value
     * @param string $seasonDesc
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setSeasonDesc($seasonDesc = null)
    {
        // validation for constraint: string
        if (!is_null($seasonDesc) && !is_string($seasonDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seasonDesc)), __LINE__);
        }
        $this->seasonDesc = $seasonDesc;
        return $this;
    }
    /**
     * Get categoryCode value
     * @return string|null
     */
    public function getCategoryCode()
    {
        return $this->categoryCode;
    }
    /**
     * Set categoryCode value
     * @param string $categoryCode
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setCategoryCode($categoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($categoryCode) && !is_string($categoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryCode)), __LINE__);
        }
        $this->categoryCode = $categoryCode;
        return $this;
    }
    /**
     * Get categoryDesc value
     * @return string|null
     */
    public function getCategoryDesc()
    {
        return $this->categoryDesc;
    }
    /**
     * Set categoryDesc value
     * @param string $categoryDesc
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setCategoryDesc($categoryDesc = null)
    {
        // validation for constraint: string
        if (!is_null($categoryDesc) && !is_string($categoryDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryDesc)), __LINE__);
        }
        $this->categoryDesc = $categoryDesc;
        return $this;
    }
    /**
     * Get collectionId value
     * @return string|null
     */
    public function getCollectionId()
    {
        return $this->collectionId;
    }
    /**
     * Set collectionId value
     * @param string $collectionId
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setCollectionId($collectionId = null)
    {
        // validation for constraint: string
        if (!is_null($collectionId) && !is_string($collectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($collectionId)), __LINE__);
        }
        $this->collectionId = $collectionId;
        return $this;
    }
    /**
     * Get collectionDesc value
     * @return string|null
     */
    public function getCollectionDesc()
    {
        return $this->collectionDesc;
    }
    /**
     * Set collectionDesc value
     * @param string $collectionDesc
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setCollectionDesc($collectionDesc = null)
    {
        // validation for constraint: string
        if (!is_null($collectionDesc) && !is_string($collectionDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($collectionDesc)), __LINE__);
        }
        $this->collectionDesc = $collectionDesc;
        return $this;
    }
    /**
     * Get minimalOrderQuantity value
     * @return int|null
     */
    public function getMinimalOrderQuantity()
    {
        return $this->minimalOrderQuantity;
    }
    /**
     * Set minimalOrderQuantity value
     * @param int $minimalOrderQuantity
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setMinimalOrderQuantity($minimalOrderQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($minimalOrderQuantity) && !is_numeric($minimalOrderQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minimalOrderQuantity)), __LINE__);
        }
        $this->minimalOrderQuantity = $minimalOrderQuantity;
        return $this;
    }
    /**
     * Get minimumQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XMinimumQuantity30[]|null
     */
    public function getMinimumQuantity()
    {
        return isset($this->minimumQuantity) ? $this->minimumQuantity : null;
    }
    /**
     * Set minimumQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XMinimumQuantity30[] $minimumQuantity
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setMinimumQuantity(array $minimumQuantity = array())
    {
        foreach ($minimumQuantity as $xProduct30MinimumQuantityItem) {
            // validation for constraint: itemType
            if (!$xProduct30MinimumQuantityItem instanceof \ApptitudeNamespace\StructType\XMinimumQuantity30) {
                throw new \InvalidArgumentException(sprintf('The minimumQuantity property can only contain items of \ApptitudeNamespace\StructType\XMinimumQuantity30, "%s" given', is_object($xProduct30MinimumQuantityItem) ? get_class($xProduct30MinimumQuantityItem) : gettype($xProduct30MinimumQuantityItem)), __LINE__);
            }
        }
        if (is_null($minimumQuantity) || (is_array($minimumQuantity) && empty($minimumQuantity))) {
            unset($this->minimumQuantity);
        } else {
            $this->minimumQuantity = $minimumQuantity;
        }
        return $this;
    }
    /**
     * Add item to minimumQuantity value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XMinimumQuantity30 $item
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function addToMinimumQuantity(\ApptitudeNamespace\StructType\XMinimumQuantity30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XMinimumQuantity30) {
            throw new \InvalidArgumentException(sprintf('The minimumQuantity property can only contain items of \ApptitudeNamespace\StructType\XMinimumQuantity30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->minimumQuantity[] = $item;
        return $this;
    }
    /**
     * Get deliveryStartDate value
     * @return string|null
     */
    public function getDeliveryStartDate()
    {
        return $this->deliveryStartDate;
    }
    /**
     * Set deliveryStartDate value
     * @param string $deliveryStartDate
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setDeliveryStartDate($deliveryStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryStartDate) && !is_string($deliveryStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryStartDate)), __LINE__);
        }
        $this->deliveryStartDate = $deliveryStartDate;
        return $this;
    }
    /**
     * Get deliveryEndDate value
     * @return string|null
     */
    public function getDeliveryEndDate()
    {
        return $this->deliveryEndDate;
    }
    /**
     * Set deliveryEndDate value
     * @param string $deliveryEndDate
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setDeliveryEndDate($deliveryEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryEndDate) && !is_string($deliveryEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryEndDate)), __LINE__);
        }
        $this->deliveryEndDate = $deliveryEndDate;
        return $this;
    }
    /**
     * Get firstReceiptDate value
     * @return string|null
     */
    public function getFirstReceiptDate()
    {
        return $this->firstReceiptDate;
    }
    /**
     * Set firstReceiptDate value
     * @param string $firstReceiptDate
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setFirstReceiptDate($firstReceiptDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstReceiptDate) && !is_string($firstReceiptDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstReceiptDate)), __LINE__);
        }
        $this->firstReceiptDate = $firstReceiptDate;
        return $this;
    }
    /**
     * Get productGroupCode value
     * @return string|null
     */
    public function getProductGroupCode()
    {
        return $this->productGroupCode;
    }
    /**
     * Set productGroupCode value
     * @param string $productGroupCode
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setProductGroupCode($productGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($productGroupCode) && !is_string($productGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productGroupCode)), __LINE__);
        }
        $this->productGroupCode = $productGroupCode;
        return $this;
    }
    /**
     * Get productGroupDesc value
     * @return string|null
     */
    public function getProductGroupDesc()
    {
        return $this->productGroupDesc;
    }
    /**
     * Set productGroupDesc value
     * @param string $productGroupDesc
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setProductGroupDesc($productGroupDesc = null)
    {
        // validation for constraint: string
        if (!is_null($productGroupDesc) && !is_string($productGroupDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productGroupDesc)), __LINE__);
        }
        $this->productGroupDesc = $productGroupDesc;
        return $this;
    }
    /**
     * Get price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XPrice30[]|null
     */
    public function getPrice()
    {
        return isset($this->price) ? $this->price : null;
    }
    /**
     * Set price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XPrice30[] $price
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setPrice(array $price = array())
    {
        foreach ($price as $xProduct30PriceItem) {
            // validation for constraint: itemType
            if (!$xProduct30PriceItem instanceof \ApptitudeNamespace\StructType\XPrice30) {
                throw new \InvalidArgumentException(sprintf('The price property can only contain items of \ApptitudeNamespace\StructType\XPrice30, "%s" given', is_object($xProduct30PriceItem) ? get_class($xProduct30PriceItem) : gettype($xProduct30PriceItem)), __LINE__);
            }
        }
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->price);
        } else {
            $this->price = $price;
        }
        return $this;
    }
    /**
     * Add item to price value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XPrice30 $item
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function addToPrice(\ApptitudeNamespace\StructType\XPrice30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XPrice30) {
            throw new \InvalidArgumentException(sprintf('The price property can only contain items of \ApptitudeNamespace\StructType\XPrice30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->price[] = $item;
        return $this;
    }
    /**
     * Get size value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XSize30[]|null
     */
    public function getSize()
    {
        return isset($this->size) ? $this->size : null;
    }
    /**
     * Set size value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XSize30[] $size
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setSize(array $size = array())
    {
        foreach ($size as $xProduct30SizeItem) {
            // validation for constraint: itemType
            if (!$xProduct30SizeItem instanceof \ApptitudeNamespace\StructType\XSize30) {
                throw new \InvalidArgumentException(sprintf('The size property can only contain items of \ApptitudeNamespace\StructType\XSize30, "%s" given', is_object($xProduct30SizeItem) ? get_class($xProduct30SizeItem) : gettype($xProduct30SizeItem)), __LINE__);
            }
        }
        if (is_null($size) || (is_array($size) && empty($size))) {
            unset($this->size);
        } else {
            $this->size = $size;
        }
        return $this;
    }
    /**
     * Add item to size value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XSize30 $item
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function addToSize(\ApptitudeNamespace\StructType\XSize30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XSize30) {
            throw new \InvalidArgumentException(sprintf('The size property can only contain items of \ApptitudeNamespace\StructType\XSize30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->size[] = $item;
        return $this;
    }
    /**
     * Get sale value
     * @return string|null
     */
    public function getSale()
    {
        return $this->sale;
    }
    /**
     * Set sale value
     * @param string $sale
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setSale($sale = null)
    {
        // validation for constraint: string
        if (!is_null($sale) && !is_string($sale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sale)), __LINE__);
        }
        $this->sale = $sale;
        return $this;
    }
    /**
     * Get saleBackgroundColor value
     * @return string|null
     */
    public function getSaleBackgroundColor()
    {
        return $this->saleBackgroundColor;
    }
    /**
     * Set saleBackgroundColor value
     * @param string $saleBackgroundColor
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setSaleBackgroundColor($saleBackgroundColor = null)
    {
        // validation for constraint: string
        if (!is_null($saleBackgroundColor) && !is_string($saleBackgroundColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($saleBackgroundColor)), __LINE__);
        }
        $this->saleBackgroundColor = $saleBackgroundColor;
        return $this;
    }
    /**
     * Get noos value
     * @return bool|null
     */
    public function getNoos()
    {
        return $this->noos;
    }
    /**
     * Set noos value
     * @param bool $noos
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setNoos($noos = null)
    {
        // validation for constraint: boolean
        if (!is_null($noos) && !is_bool($noos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($noos)), __LINE__);
        }
        $this->noos = $noos;
        return $this;
    }
    /**
     * Get medium value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XMedium30[]|null
     */
    public function getMedium()
    {
        return isset($this->medium) ? $this->medium : null;
    }
    /**
     * Set medium value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XMedium30[] $medium
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setMedium(array $medium = array())
    {
        foreach ($medium as $xProduct30MediumItem) {
            // validation for constraint: itemType
            if (!$xProduct30MediumItem instanceof \ApptitudeNamespace\StructType\XMedium30) {
                throw new \InvalidArgumentException(sprintf('The medium property can only contain items of \ApptitudeNamespace\StructType\XMedium30, "%s" given', is_object($xProduct30MediumItem) ? get_class($xProduct30MediumItem) : gettype($xProduct30MediumItem)), __LINE__);
            }
        }
        if (is_null($medium) || (is_array($medium) && empty($medium))) {
            unset($this->medium);
        } else {
            $this->medium = $medium;
        }
        return $this;
    }
    /**
     * Add item to medium value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XMedium30 $item
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function addToMedium(\ApptitudeNamespace\StructType\XMedium30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XMedium30) {
            throw new \InvalidArgumentException(sprintf('The medium property can only contain items of \ApptitudeNamespace\StructType\XMedium30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->medium[] = $item;
        return $this;
    }
    /**
     * Get crossReference value
     * @return string|null
     */
    public function getCrossReference()
    {
        return $this->crossReference;
    }
    /**
     * Set crossReference value
     * @param string $crossReference
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setCrossReference($crossReference = null)
    {
        // validation for constraint: string
        if (!is_null($crossReference) && !is_string($crossReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($crossReference)), __LINE__);
        }
        $this->crossReference = $crossReference;
        return $this;
    }
    /**
     * Get extraField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XExtraField30[]|null
     */
    public function getExtraField()
    {
        return isset($this->extraField) ? $this->extraField : null;
    }
    /**
     * Set extraField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XExtraField30[] $extraField
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setExtraField(array $extraField = array())
    {
        foreach ($extraField as $xProduct30ExtraFieldItem) {
            // validation for constraint: itemType
            if (!$xProduct30ExtraFieldItem instanceof \ApptitudeNamespace\StructType\XExtraField30) {
                throw new \InvalidArgumentException(sprintf('The extraField property can only contain items of \ApptitudeNamespace\StructType\XExtraField30, "%s" given', is_object($xProduct30ExtraFieldItem) ? get_class($xProduct30ExtraFieldItem) : gettype($xProduct30ExtraFieldItem)), __LINE__);
            }
        }
        if (is_null($extraField) || (is_array($extraField) && empty($extraField))) {
            unset($this->extraField);
        } else {
            $this->extraField = $extraField;
        }
        return $this;
    }
    /**
     * Add item to extraField value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XExtraField30 $item
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function addToExtraField(\ApptitudeNamespace\StructType\XExtraField30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XExtraField30) {
            throw new \InvalidArgumentException(sprintf('The extraField property can only contain items of \ApptitudeNamespace\StructType\XExtraField30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->extraField[] = $item;
        return $this;
    }
    /**
     * Get searchText value
     * @return string|null
     */
    public function getSearchText()
    {
        return $this->searchText;
    }
    /**
     * Set searchText value
     * @param string $searchText
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setSearchText($searchText = null)
    {
        // validation for constraint: string
        if (!is_null($searchText) && !is_string($searchText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchText)), __LINE__);
        }
        $this->searchText = $searchText;
        return $this;
    }
    /**
     * Get deliverySubBlock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getDeliverySubBlock()
    {
        return isset($this->deliverySubBlock) ? $this->deliverySubBlock : null;
    }
    /**
     * Set deliverySubBlock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $deliverySubBlock
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setDeliverySubBlock(array $deliverySubBlock = array())
    {
        foreach ($deliverySubBlock as $xProduct30DeliverySubBlockItem) {
            // validation for constraint: itemType
            if (!is_string($xProduct30DeliverySubBlockItem)) {
                throw new \InvalidArgumentException(sprintf('The deliverySubBlock property can only contain items of string, "%s" given', is_object($xProduct30DeliverySubBlockItem) ? get_class($xProduct30DeliverySubBlockItem) : gettype($xProduct30DeliverySubBlockItem)), __LINE__);
            }
        }
        if (is_null($deliverySubBlock) || (is_array($deliverySubBlock) && empty($deliverySubBlock))) {
            unset($this->deliverySubBlock);
        } else {
            $this->deliverySubBlock = $deliverySubBlock;
        }
        return $this;
    }
    /**
     * Add item to deliverySubBlock value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function addToDeliverySubBlock($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The deliverySubBlock property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->deliverySubBlock[] = $item;
        return $this;
    }
    /**
     * Get deliveryWindow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XDeliveryWindow30[]|null
     */
    public function getDeliveryWindow()
    {
        return isset($this->deliveryWindow) ? $this->deliveryWindow : null;
    }
    /**
     * Set deliveryWindow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XDeliveryWindow30[] $deliveryWindow
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setDeliveryWindow(array $deliveryWindow = array())
    {
        foreach ($deliveryWindow as $xProduct30DeliveryWindowItem) {
            // validation for constraint: itemType
            if (!$xProduct30DeliveryWindowItem instanceof \ApptitudeNamespace\StructType\XDeliveryWindow30) {
                throw new \InvalidArgumentException(sprintf('The deliveryWindow property can only contain items of \ApptitudeNamespace\StructType\XDeliveryWindow30, "%s" given', is_object($xProduct30DeliveryWindowItem) ? get_class($xProduct30DeliveryWindowItem) : gettype($xProduct30DeliveryWindowItem)), __LINE__);
            }
        }
        if (is_null($deliveryWindow) || (is_array($deliveryWindow) && empty($deliveryWindow))) {
            unset($this->deliveryWindow);
        } else {
            $this->deliveryWindow = $deliveryWindow;
        }
        return $this;
    }
    /**
     * Add item to deliveryWindow value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XDeliveryWindow30 $item
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function addToDeliveryWindow(\ApptitudeNamespace\StructType\XDeliveryWindow30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XDeliveryWindow30) {
            throw new \InvalidArgumentException(sprintf('The deliveryWindow property can only contain items of \ApptitudeNamespace\StructType\XDeliveryWindow30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->deliveryWindow[] = $item;
        return $this;
    }
    /**
     * Get gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->gender;
    }
    /**
     * Set gender value
     * @param string $gender
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gender)), __LINE__);
        }
        $this->gender = $gender;
        return $this;
    }
    /**
     * Get sortCode value
     * @return int|null
     */
    public function getSortCode()
    {
        return $this->sortCode;
    }
    /**
     * Set sortCode value
     * @param int $sortCode
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setSortCode($sortCode = null)
    {
        // validation for constraint: int
        if (!is_null($sortCode) && !is_numeric($sortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortCode)), __LINE__);
        }
        $this->sortCode = $sortCode;
        return $this;
    }
    /**
     * Get userDefinedField1 value
     * @return string|null
     */
    public function getUserDefinedField1()
    {
        return $this->userDefinedField1;
    }
    /**
     * Set userDefinedField1 value
     * @param string $userDefinedField1
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setUserDefinedField1($userDefinedField1 = null)
    {
        // validation for constraint: string
        if (!is_null($userDefinedField1) && !is_string($userDefinedField1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userDefinedField1)), __LINE__);
        }
        $this->userDefinedField1 = $userDefinedField1;
        return $this;
    }
    /**
     * Get userDefinedField2 value
     * @return string|null
     */
    public function getUserDefinedField2()
    {
        return $this->userDefinedField2;
    }
    /**
     * Set userDefinedField2 value
     * @param string $userDefinedField2
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setUserDefinedField2($userDefinedField2 = null)
    {
        // validation for constraint: string
        if (!is_null($userDefinedField2) && !is_string($userDefinedField2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userDefinedField2)), __LINE__);
        }
        $this->userDefinedField2 = $userDefinedField2;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \ApptitudeNamespace\EnumType\XProductStatus30::valueIsValid()
     * @uses \ApptitudeNamespace\EnumType\XProductStatus30::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\ApptitudeNamespace\EnumType\XProductStatus30::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \ApptitudeNamespace\EnumType\XProductStatus30::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get summary value
     * @return string|null
     */
    public function getSummary()
    {
        return $this->summary;
    }
    /**
     * Set summary value
     * @param string $summary
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setSummary($summary = null)
    {
        // validation for constraint: string
        if (!is_null($summary) && !is_string($summary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($summary)), __LINE__);
        }
        $this->summary = $summary;
        return $this;
    }
    /**
     * Get fit value
     * @return string|null
     */
    public function getFit()
    {
        return $this->fit;
    }
    /**
     * Set fit value
     * @param string $fit
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setFit($fit = null)
    {
        // validation for constraint: string
        if (!is_null($fit) && !is_string($fit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fit)), __LINE__);
        }
        $this->fit = $fit;
        return $this;
    }
    /**
     * Get marginGroupCode value
     * @return string|null
     */
    public function getMarginGroupCode()
    {
        return $this->marginGroupCode;
    }
    /**
     * Set marginGroupCode value
     * @param string $marginGroupCode
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setMarginGroupCode($marginGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($marginGroupCode) && !is_string($marginGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marginGroupCode)), __LINE__);
        }
        $this->marginGroupCode = $marginGroupCode;
        return $this;
    }
    /**
     * Get discountGroupCode value
     * @return string|null
     */
    public function getDiscountGroupCode()
    {
        return $this->discountGroupCode;
    }
    /**
     * Set discountGroupCode value
     * @param string $discountGroupCode
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setDiscountGroupCode($discountGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountGroupCode) && !is_string($discountGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discountGroupCode)), __LINE__);
        }
        $this->discountGroupCode = $discountGroupCode;
        return $this;
    }
    /**
     * Get styleAttributes value
     * @return string|null
     */
    public function getStyleAttributes()
    {
        return $this->styleAttributes;
    }
    /**
     * Set styleAttributes value
     * @param string $styleAttributes
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setStyleAttributes($styleAttributes = null)
    {
        // validation for constraint: string
        if (!is_null($styleAttributes) && !is_string($styleAttributes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($styleAttributes)), __LINE__);
        }
        $this->styleAttributes = $styleAttributes;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get sizeIndependentStockLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XStockLevel30[]|null
     */
    public function getSizeIndependentStockLevel()
    {
        return isset($this->sizeIndependentStockLevel) ? $this->sizeIndependentStockLevel : null;
    }
    /**
     * Set sizeIndependentStockLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XStockLevel30[] $sizeIndependentStockLevel
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function setSizeIndependentStockLevel(array $sizeIndependentStockLevel = array())
    {
        foreach ($sizeIndependentStockLevel as $xProduct30SizeIndependentStockLevelItem) {
            // validation for constraint: itemType
            if (!$xProduct30SizeIndependentStockLevelItem instanceof \ApptitudeNamespace\StructType\XStockLevel30) {
                throw new \InvalidArgumentException(sprintf('The sizeIndependentStockLevel property can only contain items of \ApptitudeNamespace\StructType\XStockLevel30, "%s" given', is_object($xProduct30SizeIndependentStockLevelItem) ? get_class($xProduct30SizeIndependentStockLevelItem) : gettype($xProduct30SizeIndependentStockLevelItem)), __LINE__);
            }
        }
        if (is_null($sizeIndependentStockLevel) || (is_array($sizeIndependentStockLevel) && empty($sizeIndependentStockLevel))) {
            unset($this->sizeIndependentStockLevel);
        } else {
            $this->sizeIndependentStockLevel = $sizeIndependentStockLevel;
        }
        return $this;
    }
    /**
     * Add item to sizeIndependentStockLevel value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XStockLevel30 $item
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public function addToSizeIndependentStockLevel(\ApptitudeNamespace\StructType\XStockLevel30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XStockLevel30) {
            throw new \InvalidArgumentException(sprintf('The sizeIndependentStockLevel property can only contain items of \ApptitudeNamespace\StructType\XStockLevel30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->sizeIndependentStockLevel[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\XProduct30
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
