<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xPrice30 StructType
 * @subpackage Structs
 */
class XPrice30 extends XObject30
{
    /**
     * The currencyCode
     * @var string
     */
    public $currencyCode;
    /**
     * The priceGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $priceGroup;
    /**
     * The customerNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerNo;
    /**
     * The sizeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sizeName;
    /**
     * The subSizeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subSizeName;
    /**
     * The eanCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $eanCode;
    /**
     * The retailPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $retailPrice;
    /**
     * The wholesalePrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $wholesalePrice;
    /**
     * The originalWholesalePrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $originalWholesalePrice;
    /**
     * The originalRetailPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $originalRetailPrice;
    /**
     * The purchasePrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchasePrice;
    /**
     * The net
     * @var bool
     */
    public $net;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * Constructor method for xPrice30
     * @uses XPrice30::setCurrencyCode()
     * @uses XPrice30::setPriceGroup()
     * @uses XPrice30::setCustomerNo()
     * @uses XPrice30::setSizeName()
     * @uses XPrice30::setSubSizeName()
     * @uses XPrice30::setEanCode()
     * @uses XPrice30::setRetailPrice()
     * @uses XPrice30::setWholesalePrice()
     * @uses XPrice30::setOriginalWholesalePrice()
     * @uses XPrice30::setOriginalRetailPrice()
     * @uses XPrice30::setPurchasePrice()
     * @uses XPrice30::setNet()
     * @uses XPrice30::setStartDate()
     * @uses XPrice30::setEndDate()
     * @param string $currencyCode
     * @param string $priceGroup
     * @param string $customerNo
     * @param string $sizeName
     * @param string $subSizeName
     * @param string $eanCode
     * @param float $retailPrice
     * @param float $wholesalePrice
     * @param float $originalWholesalePrice
     * @param float $originalRetailPrice
     * @param float $purchasePrice
     * @param bool $net
     * @param string $startDate
     * @param string $endDate
     */
    public function __construct($currencyCode = null, $priceGroup = null, $customerNo = null, $sizeName = null, $subSizeName = null, $eanCode = null, $retailPrice = null, $wholesalePrice = null, $originalWholesalePrice = null, $originalRetailPrice = null, $purchasePrice = null, $net = null, $startDate = null, $endDate = null)
    {
        $this
            ->setCurrencyCode($currencyCode)
            ->setPriceGroup($priceGroup)
            ->setCustomerNo($customerNo)
            ->setSizeName($sizeName)
            ->setSubSizeName($subSizeName)
            ->setEanCode($eanCode)
            ->setRetailPrice($retailPrice)
            ->setWholesalePrice($wholesalePrice)
            ->setOriginalWholesalePrice($originalWholesalePrice)
            ->setOriginalRetailPrice($originalRetailPrice)
            ->setPurchasePrice($purchasePrice)
            ->setNet($net)
            ->setStartDate($startDate)
            ->setEndDate($endDate);
    }
    /**
     * Get currencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }
    /**
     * Set currencyCode value
     * @param string $currencyCode
     * @return \ApptitudeNamespace\StructType\XPrice30
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->currencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get priceGroup value
     * @return string|null
     */
    public function getPriceGroup()
    {
        return $this->priceGroup;
    }
    /**
     * Set priceGroup value
     * @param string $priceGroup
     * @return \ApptitudeNamespace\StructType\XPrice30
     */
    public function setPriceGroup($priceGroup = null)
    {
        // validation for constraint: string
        if (!is_null($priceGroup) && !is_string($priceGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priceGroup)), __LINE__);
        }
        $this->priceGroup = $priceGroup;
        return $this;
    }
    /**
     * Get customerNo value
     * @return string|null
     */
    public function getCustomerNo()
    {
        return $this->customerNo;
    }
    /**
     * Set customerNo value
     * @param string $customerNo
     * @return \ApptitudeNamespace\StructType\XPrice30
     */
    public function setCustomerNo($customerNo = null)
    {
        // validation for constraint: string
        if (!is_null($customerNo) && !is_string($customerNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerNo)), __LINE__);
        }
        $this->customerNo = $customerNo;
        return $this;
    }
    /**
     * Get sizeName value
     * @return string|null
     */
    public function getSizeName()
    {
        return $this->sizeName;
    }
    /**
     * Set sizeName value
     * @param string $sizeName
     * @return \ApptitudeNamespace\StructType\XPrice30
     */
    public function setSizeName($sizeName = null)
    {
        // validation for constraint: string
        if (!is_null($sizeName) && !is_string($sizeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sizeName)), __LINE__);
        }
        $this->sizeName = $sizeName;
        return $this;
    }
    /**
     * Get subSizeName value
     * @return string|null
     */
    public function getSubSizeName()
    {
        return $this->subSizeName;
    }
    /**
     * Set subSizeName value
     * @param string $subSizeName
     * @return \ApptitudeNamespace\StructType\XPrice30
     */
    public function setSubSizeName($subSizeName = null)
    {
        // validation for constraint: string
        if (!is_null($subSizeName) && !is_string($subSizeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subSizeName)), __LINE__);
        }
        $this->subSizeName = $subSizeName;
        return $this;
    }
    /**
     * Get eanCode value
     * @return string|null
     */
    public function getEanCode()
    {
        return $this->eanCode;
    }
    /**
     * Set eanCode value
     * @param string $eanCode
     * @return \ApptitudeNamespace\StructType\XPrice30
     */
    public function setEanCode($eanCode = null)
    {
        // validation for constraint: string
        if (!is_null($eanCode) && !is_string($eanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eanCode)), __LINE__);
        }
        $this->eanCode = $eanCode;
        return $this;
    }
    /**
     * Get retailPrice value
     * @return float|null
     */
    public function getRetailPrice()
    {
        return $this->retailPrice;
    }
    /**
     * Set retailPrice value
     * @param float $retailPrice
     * @return \ApptitudeNamespace\StructType\XPrice30
     */
    public function setRetailPrice($retailPrice = null)
    {
        $this->retailPrice = $retailPrice;
        return $this;
    }
    /**
     * Get wholesalePrice value
     * @return float|null
     */
    public function getWholesalePrice()
    {
        return $this->wholesalePrice;
    }
    /**
     * Set wholesalePrice value
     * @param float $wholesalePrice
     * @return \ApptitudeNamespace\StructType\XPrice30
     */
    public function setWholesalePrice($wholesalePrice = null)
    {
        $this->wholesalePrice = $wholesalePrice;
        return $this;
    }
    /**
     * Get originalWholesalePrice value
     * @return float|null
     */
    public function getOriginalWholesalePrice()
    {
        return $this->originalWholesalePrice;
    }
    /**
     * Set originalWholesalePrice value
     * @param float $originalWholesalePrice
     * @return \ApptitudeNamespace\StructType\XPrice30
     */
    public function setOriginalWholesalePrice($originalWholesalePrice = null)
    {
        $this->originalWholesalePrice = $originalWholesalePrice;
        return $this;
    }
    /**
     * Get originalRetailPrice value
     * @return float|null
     */
    public function getOriginalRetailPrice()
    {
        return $this->originalRetailPrice;
    }
    /**
     * Set originalRetailPrice value
     * @param float $originalRetailPrice
     * @return \ApptitudeNamespace\StructType\XPrice30
     */
    public function setOriginalRetailPrice($originalRetailPrice = null)
    {
        $this->originalRetailPrice = $originalRetailPrice;
        return $this;
    }
    /**
     * Get purchasePrice value
     * @return float|null
     */
    public function getPurchasePrice()
    {
        return $this->purchasePrice;
    }
    /**
     * Set purchasePrice value
     * @param float $purchasePrice
     * @return \ApptitudeNamespace\StructType\XPrice30
     */
    public function setPurchasePrice($purchasePrice = null)
    {
        $this->purchasePrice = $purchasePrice;
        return $this;
    }
    /**
     * Get net value
     * @return bool|null
     */
    public function getNet()
    {
        return $this->net;
    }
    /**
     * Set net value
     * @param bool $net
     * @return \ApptitudeNamespace\StructType\XPrice30
     */
    public function setNet($net = null)
    {
        // validation for constraint: boolean
        if (!is_null($net) && !is_bool($net)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($net)), __LINE__);
        }
        $this->net = $net;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \ApptitudeNamespace\StructType\XPrice30
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \ApptitudeNamespace\StructType\XPrice30
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\XPrice30
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
