<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xOrder30 StructType
 * @subpackage Structs
 */
class XOrder30 extends XObject30
{
    /**
     * The collectionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $collectionId;
    /**
     * The orderNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderNumber;
    /**
     * The trackingNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $trackingNumber;
    /**
     * The canceledOrderNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $canceledOrderNumber;
    /**
     * The timestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timestamp;
    /**
     * The serverTimestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serverTimestamp;
    /**
     * The signed
     * @var bool
     */
    public $signed;
    /**
     * The salesPerson
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salesPerson;
    /**
     * The customerNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerNo;
    /**
     * The shippingLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XLocation30
     */
    public $shippingLocation;
    /**
     * The consumerLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XLocation30
     */
    public $consumerLocation;
    /**
     * The storeLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XLocation30
     */
    public $storeLocation;
    /**
     * The customerPriceGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerPriceGroup;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The signee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $signee;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The internalComment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $internalComment;
    /**
     * The orderLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XOrderLine30[]
     */
    public $orderLine;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The customerOrderReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerOrderReference;
    /**
     * The requestedDeliveryDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $requestedDeliveryDate;
    /**
     * The requestedDeliveryEndDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $requestedDeliveryEndDate;
    /**
     * The numberOfBoxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numberOfBoxes;
    /**
     * The returnsContact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $returnsContact;
    /**
     * The draftOrderNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $draftOrderNumber;
    /**
     * The totalCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalCount;
    /**
     * The totalAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalAmount;
    /**
     * The approvalInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $approvalInfo;
    /**
     * The freeTextField1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $freeTextField1;
    /**
     * The freeTextField2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $freeTextField2;
    /**
     * The orderTypeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderTypeCode;
    /**
     * The contact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XContact30
     */
    public $contact;
    /**
     * The agreement
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XAgreement30
     */
    public $agreement;
    /**
     * The customChoice
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XCustomChoice30[]
     */
    public $customChoice;
    /**
     * The discountRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XOrderAmountModificationRule30[]
     */
    public $discountRule;
    /**
     * The deliveryCostRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XOrderAmountModificationRule30[]
     */
    public $deliveryCostRule;
    /**
     * The orderConfirmation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XOrderConfirmation30
     */
    public $orderConfirmation;
    /**
     * Constructor method for xOrder30
     * @uses XOrder30::setCollectionId()
     * @uses XOrder30::setOrderNumber()
     * @uses XOrder30::setTrackingNumber()
     * @uses XOrder30::setCanceledOrderNumber()
     * @uses XOrder30::setTimestamp()
     * @uses XOrder30::setServerTimestamp()
     * @uses XOrder30::setSigned()
     * @uses XOrder30::setSalesPerson()
     * @uses XOrder30::setCustomerNo()
     * @uses XOrder30::setShippingLocation()
     * @uses XOrder30::setConsumerLocation()
     * @uses XOrder30::setStoreLocation()
     * @uses XOrder30::setCustomerPriceGroup()
     * @uses XOrder30::setCurrency()
     * @uses XOrder30::setSignee()
     * @uses XOrder30::setComment()
     * @uses XOrder30::setInternalComment()
     * @uses XOrder30::setOrderLine()
     * @uses XOrder30::setStatus()
     * @uses XOrder30::setCustomerOrderReference()
     * @uses XOrder30::setRequestedDeliveryDate()
     * @uses XOrder30::setRequestedDeliveryEndDate()
     * @uses XOrder30::setNumberOfBoxes()
     * @uses XOrder30::setReturnsContact()
     * @uses XOrder30::setDraftOrderNumber()
     * @uses XOrder30::setTotalCount()
     * @uses XOrder30::setTotalAmount()
     * @uses XOrder30::setApprovalInfo()
     * @uses XOrder30::setFreeTextField1()
     * @uses XOrder30::setFreeTextField2()
     * @uses XOrder30::setOrderTypeCode()
     * @uses XOrder30::setContact()
     * @uses XOrder30::setAgreement()
     * @uses XOrder30::setCustomChoice()
     * @uses XOrder30::setDiscountRule()
     * @uses XOrder30::setDeliveryCostRule()
     * @uses XOrder30::setOrderConfirmation()
     * @param string $collectionId
     * @param string $orderNumber
     * @param string $trackingNumber
     * @param string $canceledOrderNumber
     * @param string $timestamp
     * @param string $serverTimestamp
     * @param bool $signed
     * @param string $salesPerson
     * @param string $customerNo
     * @param \ApptitudeNamespace\StructType\XLocation30 $shippingLocation
     * @param \ApptitudeNamespace\StructType\XLocation30 $consumerLocation
     * @param \ApptitudeNamespace\StructType\XLocation30 $storeLocation
     * @param string $customerPriceGroup
     * @param string $currency
     * @param string $signee
     * @param string $comment
     * @param string $internalComment
     * @param \ApptitudeNamespace\StructType\XOrderLine30[] $orderLine
     * @param string $status
     * @param string $customerOrderReference
     * @param string $requestedDeliveryDate
     * @param string $requestedDeliveryEndDate
     * @param int $numberOfBoxes
     * @param string $returnsContact
     * @param string $draftOrderNumber
     * @param int $totalCount
     * @param float $totalAmount
     * @param string $approvalInfo
     * @param string $freeTextField1
     * @param string $freeTextField2
     * @param string $orderTypeCode
     * @param \ApptitudeNamespace\StructType\XContact30 $contact
     * @param \ApptitudeNamespace\StructType\XAgreement30 $agreement
     * @param \ApptitudeNamespace\StructType\XCustomChoice30[] $customChoice
     * @param \ApptitudeNamespace\StructType\XOrderAmountModificationRule30[] $discountRule
     * @param \ApptitudeNamespace\StructType\XOrderAmountModificationRule30[] $deliveryCostRule
     * @param \ApptitudeNamespace\StructType\XOrderConfirmation30 $orderConfirmation
     */
    public function __construct($collectionId = null, $orderNumber = null, $trackingNumber = null, $canceledOrderNumber = null, $timestamp = null, $serverTimestamp = null, $signed = null, $salesPerson = null, $customerNo = null, \ApptitudeNamespace\StructType\XLocation30 $shippingLocation = null, \ApptitudeNamespace\StructType\XLocation30 $consumerLocation = null, \ApptitudeNamespace\StructType\XLocation30 $storeLocation = null, $customerPriceGroup = null, $currency = null, $signee = null, $comment = null, $internalComment = null, array $orderLine = array(), $status = null, $customerOrderReference = null, $requestedDeliveryDate = null, $requestedDeliveryEndDate = null, $numberOfBoxes = null, $returnsContact = null, $draftOrderNumber = null, $totalCount = null, $totalAmount = null, $approvalInfo = null, $freeTextField1 = null, $freeTextField2 = null, $orderTypeCode = null, \ApptitudeNamespace\StructType\XContact30 $contact = null, \ApptitudeNamespace\StructType\XAgreement30 $agreement = null, array $customChoice = array(), array $discountRule = array(), array $deliveryCostRule = array(), \ApptitudeNamespace\StructType\XOrderConfirmation30 $orderConfirmation = null)
    {
        $this
            ->setCollectionId($collectionId)
            ->setOrderNumber($orderNumber)
            ->setTrackingNumber($trackingNumber)
            ->setCanceledOrderNumber($canceledOrderNumber)
            ->setTimestamp($timestamp)
            ->setServerTimestamp($serverTimestamp)
            ->setSigned($signed)
            ->setSalesPerson($salesPerson)
            ->setCustomerNo($customerNo)
            ->setShippingLocation($shippingLocation)
            ->setConsumerLocation($consumerLocation)
            ->setStoreLocation($storeLocation)
            ->setCustomerPriceGroup($customerPriceGroup)
            ->setCurrency($currency)
            ->setSignee($signee)
            ->setComment($comment)
            ->setInternalComment($internalComment)
            ->setOrderLine($orderLine)
            ->setStatus($status)
            ->setCustomerOrderReference($customerOrderReference)
            ->setRequestedDeliveryDate($requestedDeliveryDate)
            ->setRequestedDeliveryEndDate($requestedDeliveryEndDate)
            ->setNumberOfBoxes($numberOfBoxes)
            ->setReturnsContact($returnsContact)
            ->setDraftOrderNumber($draftOrderNumber)
            ->setTotalCount($totalCount)
            ->setTotalAmount($totalAmount)
            ->setApprovalInfo($approvalInfo)
            ->setFreeTextField1($freeTextField1)
            ->setFreeTextField2($freeTextField2)
            ->setOrderTypeCode($orderTypeCode)
            ->setContact($contact)
            ->setAgreement($agreement)
            ->setCustomChoice($customChoice)
            ->setDiscountRule($discountRule)
            ->setDeliveryCostRule($deliveryCostRule)
            ->setOrderConfirmation($orderConfirmation);
    }
    /**
     * Get collectionId value
     * @return string|null
     */
    public function getCollectionId()
    {
        return $this->collectionId;
    }
    /**
     * Set collectionId value
     * @param string $collectionId
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setCollectionId($collectionId = null)
    {
        // validation for constraint: string
        if (!is_null($collectionId) && !is_string($collectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($collectionId)), __LINE__);
        }
        $this->collectionId = $collectionId;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get trackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->trackingNumber;
    }
    /**
     * Set trackingNumber value
     * @param string $trackingNumber
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingNumber)), __LINE__);
        }
        $this->trackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get canceledOrderNumber value
     * @return string|null
     */
    public function getCanceledOrderNumber()
    {
        return $this->canceledOrderNumber;
    }
    /**
     * Set canceledOrderNumber value
     * @param string $canceledOrderNumber
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setCanceledOrderNumber($canceledOrderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($canceledOrderNumber) && !is_string($canceledOrderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($canceledOrderNumber)), __LINE__);
        }
        $this->canceledOrderNumber = $canceledOrderNumber;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get serverTimestamp value
     * @return string|null
     */
    public function getServerTimestamp()
    {
        return $this->serverTimestamp;
    }
    /**
     * Set serverTimestamp value
     * @param string $serverTimestamp
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setServerTimestamp($serverTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($serverTimestamp) && !is_string($serverTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serverTimestamp)), __LINE__);
        }
        $this->serverTimestamp = $serverTimestamp;
        return $this;
    }
    /**
     * Get signed value
     * @return bool|null
     */
    public function getSigned()
    {
        return $this->signed;
    }
    /**
     * Set signed value
     * @param bool $signed
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setSigned($signed = null)
    {
        // validation for constraint: boolean
        if (!is_null($signed) && !is_bool($signed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($signed)), __LINE__);
        }
        $this->signed = $signed;
        return $this;
    }
    /**
     * Get salesPerson value
     * @return string|null
     */
    public function getSalesPerson()
    {
        return $this->salesPerson;
    }
    /**
     * Set salesPerson value
     * @param string $salesPerson
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setSalesPerson($salesPerson = null)
    {
        // validation for constraint: string
        if (!is_null($salesPerson) && !is_string($salesPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesPerson)), __LINE__);
        }
        $this->salesPerson = $salesPerson;
        return $this;
    }
    /**
     * Get customerNo value
     * @return string|null
     */
    public function getCustomerNo()
    {
        return $this->customerNo;
    }
    /**
     * Set customerNo value
     * @param string $customerNo
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setCustomerNo($customerNo = null)
    {
        // validation for constraint: string
        if (!is_null($customerNo) && !is_string($customerNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerNo)), __LINE__);
        }
        $this->customerNo = $customerNo;
        return $this;
    }
    /**
     * Get shippingLocation value
     * @return \ApptitudeNamespace\StructType\XLocation30|null
     */
    public function getShippingLocation()
    {
        return $this->shippingLocation;
    }
    /**
     * Set shippingLocation value
     * @param \ApptitudeNamespace\StructType\XLocation30 $shippingLocation
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setShippingLocation(\ApptitudeNamespace\StructType\XLocation30 $shippingLocation = null)
    {
        $this->shippingLocation = $shippingLocation;
        return $this;
    }
    /**
     * Get consumerLocation value
     * @return \ApptitudeNamespace\StructType\XLocation30|null
     */
    public function getConsumerLocation()
    {
        return $this->consumerLocation;
    }
    /**
     * Set consumerLocation value
     * @param \ApptitudeNamespace\StructType\XLocation30 $consumerLocation
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setConsumerLocation(\ApptitudeNamespace\StructType\XLocation30 $consumerLocation = null)
    {
        $this->consumerLocation = $consumerLocation;
        return $this;
    }
    /**
     * Get storeLocation value
     * @return \ApptitudeNamespace\StructType\XLocation30|null
     */
    public function getStoreLocation()
    {
        return $this->storeLocation;
    }
    /**
     * Set storeLocation value
     * @param \ApptitudeNamespace\StructType\XLocation30 $storeLocation
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setStoreLocation(\ApptitudeNamespace\StructType\XLocation30 $storeLocation = null)
    {
        $this->storeLocation = $storeLocation;
        return $this;
    }
    /**
     * Get customerPriceGroup value
     * @return string|null
     */
    public function getCustomerPriceGroup()
    {
        return $this->customerPriceGroup;
    }
    /**
     * Set customerPriceGroup value
     * @param string $customerPriceGroup
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setCustomerPriceGroup($customerPriceGroup = null)
    {
        // validation for constraint: string
        if (!is_null($customerPriceGroup) && !is_string($customerPriceGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerPriceGroup)), __LINE__);
        }
        $this->customerPriceGroup = $customerPriceGroup;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get signee value
     * @return string|null
     */
    public function getSignee()
    {
        return $this->signee;
    }
    /**
     * Set signee value
     * @param string $signee
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setSignee($signee = null)
    {
        // validation for constraint: string
        if (!is_null($signee) && !is_string($signee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signee)), __LINE__);
        }
        $this->signee = $signee;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get internalComment value
     * @return string|null
     */
    public function getInternalComment()
    {
        return $this->internalComment;
    }
    /**
     * Set internalComment value
     * @param string $internalComment
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setInternalComment($internalComment = null)
    {
        // validation for constraint: string
        if (!is_null($internalComment) && !is_string($internalComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internalComment)), __LINE__);
        }
        $this->internalComment = $internalComment;
        return $this;
    }
    /**
     * Get orderLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XOrderLine30[]|null
     */
    public function getOrderLine()
    {
        return isset($this->orderLine) ? $this->orderLine : null;
    }
    /**
     * Set orderLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XOrderLine30[] $orderLine
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setOrderLine(array $orderLine = array())
    {
        foreach ($orderLine as $xOrder30OrderLineItem) {
            // validation for constraint: itemType
            if (!$xOrder30OrderLineItem instanceof \ApptitudeNamespace\StructType\XOrderLine30) {
                throw new \InvalidArgumentException(sprintf('The orderLine property can only contain items of \ApptitudeNamespace\StructType\XOrderLine30, "%s" given', is_object($xOrder30OrderLineItem) ? get_class($xOrder30OrderLineItem) : gettype($xOrder30OrderLineItem)), __LINE__);
            }
        }
        if (is_null($orderLine) || (is_array($orderLine) && empty($orderLine))) {
            unset($this->orderLine);
        } else {
            $this->orderLine = $orderLine;
        }
        return $this;
    }
    /**
     * Add item to orderLine value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XOrderLine30 $item
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function addToOrderLine(\ApptitudeNamespace\StructType\XOrderLine30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XOrderLine30) {
            throw new \InvalidArgumentException(sprintf('The orderLine property can only contain items of \ApptitudeNamespace\StructType\XOrderLine30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderLine[] = $item;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \ApptitudeNamespace\EnumType\XOrderStatus30::valueIsValid()
     * @uses \ApptitudeNamespace\EnumType\XOrderStatus30::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\ApptitudeNamespace\EnumType\XOrderStatus30::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \ApptitudeNamespace\EnumType\XOrderStatus30::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get customerOrderReference value
     * @return string|null
     */
    public function getCustomerOrderReference()
    {
        return $this->customerOrderReference;
    }
    /**
     * Set customerOrderReference value
     * @param string $customerOrderReference
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setCustomerOrderReference($customerOrderReference = null)
    {
        // validation for constraint: string
        if (!is_null($customerOrderReference) && !is_string($customerOrderReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerOrderReference)), __LINE__);
        }
        $this->customerOrderReference = $customerOrderReference;
        return $this;
    }
    /**
     * Get requestedDeliveryDate value
     * @return string|null
     */
    public function getRequestedDeliveryDate()
    {
        return $this->requestedDeliveryDate;
    }
    /**
     * Set requestedDeliveryDate value
     * @param string $requestedDeliveryDate
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setRequestedDeliveryDate($requestedDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestedDeliveryDate) && !is_string($requestedDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestedDeliveryDate)), __LINE__);
        }
        $this->requestedDeliveryDate = $requestedDeliveryDate;
        return $this;
    }
    /**
     * Get requestedDeliveryEndDate value
     * @return string|null
     */
    public function getRequestedDeliveryEndDate()
    {
        return $this->requestedDeliveryEndDate;
    }
    /**
     * Set requestedDeliveryEndDate value
     * @param string $requestedDeliveryEndDate
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setRequestedDeliveryEndDate($requestedDeliveryEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestedDeliveryEndDate) && !is_string($requestedDeliveryEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestedDeliveryEndDate)), __LINE__);
        }
        $this->requestedDeliveryEndDate = $requestedDeliveryEndDate;
        return $this;
    }
    /**
     * Get numberOfBoxes value
     * @return int|null
     */
    public function getNumberOfBoxes()
    {
        return $this->numberOfBoxes;
    }
    /**
     * Set numberOfBoxes value
     * @param int $numberOfBoxes
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setNumberOfBoxes($numberOfBoxes = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfBoxes) && !is_numeric($numberOfBoxes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfBoxes)), __LINE__);
        }
        $this->numberOfBoxes = $numberOfBoxes;
        return $this;
    }
    /**
     * Get returnsContact value
     * @return string|null
     */
    public function getReturnsContact()
    {
        return $this->returnsContact;
    }
    /**
     * Set returnsContact value
     * @param string $returnsContact
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setReturnsContact($returnsContact = null)
    {
        // validation for constraint: string
        if (!is_null($returnsContact) && !is_string($returnsContact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnsContact)), __LINE__);
        }
        $this->returnsContact = $returnsContact;
        return $this;
    }
    /**
     * Get draftOrderNumber value
     * @return string|null
     */
    public function getDraftOrderNumber()
    {
        return $this->draftOrderNumber;
    }
    /**
     * Set draftOrderNumber value
     * @param string $draftOrderNumber
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setDraftOrderNumber($draftOrderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($draftOrderNumber) && !is_string($draftOrderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($draftOrderNumber)), __LINE__);
        }
        $this->draftOrderNumber = $draftOrderNumber;
        return $this;
    }
    /**
     * Get totalCount value
     * @return int|null
     */
    public function getTotalCount()
    {
        return $this->totalCount;
    }
    /**
     * Set totalCount value
     * @param int $totalCount
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setTotalCount($totalCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalCount) && !is_numeric($totalCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalCount)), __LINE__);
        }
        $this->totalCount = $totalCount;
        return $this;
    }
    /**
     * Get totalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->totalAmount;
    }
    /**
     * Set totalAmount value
     * @param float $totalAmount
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setTotalAmount($totalAmount = null)
    {
        $this->totalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get approvalInfo value
     * @return string|null
     */
    public function getApprovalInfo()
    {
        return $this->approvalInfo;
    }
    /**
     * Set approvalInfo value
     * @param string $approvalInfo
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setApprovalInfo($approvalInfo = null)
    {
        // validation for constraint: string
        if (!is_null($approvalInfo) && !is_string($approvalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($approvalInfo)), __LINE__);
        }
        $this->approvalInfo = $approvalInfo;
        return $this;
    }
    /**
     * Get freeTextField1 value
     * @return string|null
     */
    public function getFreeTextField1()
    {
        return $this->freeTextField1;
    }
    /**
     * Set freeTextField1 value
     * @param string $freeTextField1
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setFreeTextField1($freeTextField1 = null)
    {
        // validation for constraint: string
        if (!is_null($freeTextField1) && !is_string($freeTextField1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($freeTextField1)), __LINE__);
        }
        $this->freeTextField1 = $freeTextField1;
        return $this;
    }
    /**
     * Get freeTextField2 value
     * @return string|null
     */
    public function getFreeTextField2()
    {
        return $this->freeTextField2;
    }
    /**
     * Set freeTextField2 value
     * @param string $freeTextField2
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setFreeTextField2($freeTextField2 = null)
    {
        // validation for constraint: string
        if (!is_null($freeTextField2) && !is_string($freeTextField2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($freeTextField2)), __LINE__);
        }
        $this->freeTextField2 = $freeTextField2;
        return $this;
    }
    /**
     * Get orderTypeCode value
     * @return string|null
     */
    public function getOrderTypeCode()
    {
        return $this->orderTypeCode;
    }
    /**
     * Set orderTypeCode value
     * @param string $orderTypeCode
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setOrderTypeCode($orderTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($orderTypeCode) && !is_string($orderTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderTypeCode)), __LINE__);
        }
        $this->orderTypeCode = $orderTypeCode;
        return $this;
    }
    /**
     * Get contact value
     * @return \ApptitudeNamespace\StructType\XContact30|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param \ApptitudeNamespace\StructType\XContact30 $contact
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setContact(\ApptitudeNamespace\StructType\XContact30 $contact = null)
    {
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get agreement value
     * @return \ApptitudeNamespace\StructType\XAgreement30|null
     */
    public function getAgreement()
    {
        return $this->agreement;
    }
    /**
     * Set agreement value
     * @param \ApptitudeNamespace\StructType\XAgreement30 $agreement
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setAgreement(\ApptitudeNamespace\StructType\XAgreement30 $agreement = null)
    {
        $this->agreement = $agreement;
        return $this;
    }
    /**
     * Get customChoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XCustomChoice30[]|null
     */
    public function getCustomChoice()
    {
        return isset($this->customChoice) ? $this->customChoice : null;
    }
    /**
     * Set customChoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XCustomChoice30[] $customChoice
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setCustomChoice(array $customChoice = array())
    {
        foreach ($customChoice as $xOrder30CustomChoiceItem) {
            // validation for constraint: itemType
            if (!$xOrder30CustomChoiceItem instanceof \ApptitudeNamespace\StructType\XCustomChoice30) {
                throw new \InvalidArgumentException(sprintf('The customChoice property can only contain items of \ApptitudeNamespace\StructType\XCustomChoice30, "%s" given', is_object($xOrder30CustomChoiceItem) ? get_class($xOrder30CustomChoiceItem) : gettype($xOrder30CustomChoiceItem)), __LINE__);
            }
        }
        if (is_null($customChoice) || (is_array($customChoice) && empty($customChoice))) {
            unset($this->customChoice);
        } else {
            $this->customChoice = $customChoice;
        }
        return $this;
    }
    /**
     * Add item to customChoice value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XCustomChoice30 $item
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function addToCustomChoice(\ApptitudeNamespace\StructType\XCustomChoice30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XCustomChoice30) {
            throw new \InvalidArgumentException(sprintf('The customChoice property can only contain items of \ApptitudeNamespace\StructType\XCustomChoice30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->customChoice[] = $item;
        return $this;
    }
    /**
     * Get discountRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XOrderAmountModificationRule30[]|null
     */
    public function getDiscountRule()
    {
        return isset($this->discountRule) ? $this->discountRule : null;
    }
    /**
     * Set discountRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XOrderAmountModificationRule30[] $discountRule
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setDiscountRule(array $discountRule = array())
    {
        foreach ($discountRule as $xOrder30DiscountRuleItem) {
            // validation for constraint: itemType
            if (!$xOrder30DiscountRuleItem instanceof \ApptitudeNamespace\StructType\XOrderAmountModificationRule30) {
                throw new \InvalidArgumentException(sprintf('The discountRule property can only contain items of \ApptitudeNamespace\StructType\XOrderAmountModificationRule30, "%s" given', is_object($xOrder30DiscountRuleItem) ? get_class($xOrder30DiscountRuleItem) : gettype($xOrder30DiscountRuleItem)), __LINE__);
            }
        }
        if (is_null($discountRule) || (is_array($discountRule) && empty($discountRule))) {
            unset($this->discountRule);
        } else {
            $this->discountRule = $discountRule;
        }
        return $this;
    }
    /**
     * Add item to discountRule value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XOrderAmountModificationRule30 $item
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function addToDiscountRule(\ApptitudeNamespace\StructType\XOrderAmountModificationRule30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XOrderAmountModificationRule30) {
            throw new \InvalidArgumentException(sprintf('The discountRule property can only contain items of \ApptitudeNamespace\StructType\XOrderAmountModificationRule30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->discountRule[] = $item;
        return $this;
    }
    /**
     * Get deliveryCostRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XOrderAmountModificationRule30[]|null
     */
    public function getDeliveryCostRule()
    {
        return isset($this->deliveryCostRule) ? $this->deliveryCostRule : null;
    }
    /**
     * Set deliveryCostRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XOrderAmountModificationRule30[] $deliveryCostRule
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setDeliveryCostRule(array $deliveryCostRule = array())
    {
        foreach ($deliveryCostRule as $xOrder30DeliveryCostRuleItem) {
            // validation for constraint: itemType
            if (!$xOrder30DeliveryCostRuleItem instanceof \ApptitudeNamespace\StructType\XOrderAmountModificationRule30) {
                throw new \InvalidArgumentException(sprintf('The deliveryCostRule property can only contain items of \ApptitudeNamespace\StructType\XOrderAmountModificationRule30, "%s" given', is_object($xOrder30DeliveryCostRuleItem) ? get_class($xOrder30DeliveryCostRuleItem) : gettype($xOrder30DeliveryCostRuleItem)), __LINE__);
            }
        }
        if (is_null($deliveryCostRule) || (is_array($deliveryCostRule) && empty($deliveryCostRule))) {
            unset($this->deliveryCostRule);
        } else {
            $this->deliveryCostRule = $deliveryCostRule;
        }
        return $this;
    }
    /**
     * Add item to deliveryCostRule value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XOrderAmountModificationRule30 $item
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function addToDeliveryCostRule(\ApptitudeNamespace\StructType\XOrderAmountModificationRule30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XOrderAmountModificationRule30) {
            throw new \InvalidArgumentException(sprintf('The deliveryCostRule property can only contain items of \ApptitudeNamespace\StructType\XOrderAmountModificationRule30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->deliveryCostRule[] = $item;
        return $this;
    }
    /**
     * Get orderConfirmation value
     * @return \ApptitudeNamespace\StructType\XOrderConfirmation30|null
     */
    public function getOrderConfirmation()
    {
        return $this->orderConfirmation;
    }
    /**
     * Set orderConfirmation value
     * @param \ApptitudeNamespace\StructType\XOrderConfirmation30 $orderConfirmation
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public function setOrderConfirmation(\ApptitudeNamespace\StructType\XOrderConfirmation30 $orderConfirmation = null)
    {
        $this->orderConfirmation = $orderConfirmation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\XOrder30
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
