<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xMedium30 StructType
 * @subpackage Structs
 */
class XMedium30 extends XObject30
{
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The url
     * @var string
     */
    public $url;
    /**
     * The thumbUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $thumbUrl;
    /**
     * The sortCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sortCode;
    /**
     * Constructor method for xMedium30
     * @uses XMedium30::setType()
     * @uses XMedium30::setUrl()
     * @uses XMedium30::setThumbUrl()
     * @uses XMedium30::setSortCode()
     * @param string $type
     * @param string $url
     * @param string $thumbUrl
     * @param int $sortCode
     */
    public function __construct($type = null, $url = null, $thumbUrl = null, $sortCode = null)
    {
        $this
            ->setType($type)
            ->setUrl($url)
            ->setThumbUrl($thumbUrl)
            ->setSortCode($sortCode);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \ApptitudeNamespace\EnumType\XMediumType30::valueIsValid()
     * @uses \ApptitudeNamespace\EnumType\XMediumType30::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \ApptitudeNamespace\StructType\XMedium30
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\ApptitudeNamespace\EnumType\XMediumType30::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \ApptitudeNamespace\EnumType\XMediumType30::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \ApptitudeNamespace\StructType\XMedium30
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get thumbUrl value
     * @return string|null
     */
    public function getThumbUrl()
    {
        return $this->thumbUrl;
    }
    /**
     * Set thumbUrl value
     * @param string $thumbUrl
     * @return \ApptitudeNamespace\StructType\XMedium30
     */
    public function setThumbUrl($thumbUrl = null)
    {
        // validation for constraint: string
        if (!is_null($thumbUrl) && !is_string($thumbUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($thumbUrl)), __LINE__);
        }
        $this->thumbUrl = $thumbUrl;
        return $this;
    }
    /**
     * Get sortCode value
     * @return int|null
     */
    public function getSortCode()
    {
        return $this->sortCode;
    }
    /**
     * Set sortCode value
     * @param int $sortCode
     * @return \ApptitudeNamespace\StructType\XMedium30
     */
    public function setSortCode($sortCode = null)
    {
        // validation for constraint: int
        if (!is_null($sortCode) && !is_numeric($sortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortCode)), __LINE__);
        }
        $this->sortCode = $sortCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\XMedium30
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
