<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xHistoricalOrder30 StructType
 * @subpackage Structs
 */
class XHistoricalOrder30 extends XObject30
{
    /**
     * The customerNo
     * @var string
     */
    public $customerNo;
    /**
     * The orderNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderNumber;
    /**
     * The erpOrderReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $erpOrderReference;
    /**
     * The customerOrderReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerOrderReference;
    /**
     * The collection
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $collection;
    /**
     * The timestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timestamp;
    /**
     * The salesPerson
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salesPerson;
    /**
     * The customerPriceGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerPriceGroup;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The shippingLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XLocation30
     */
    public $shippingLocation;
    /**
     * The agreement
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XAgreement30
     */
    public $agreement;
    /**
     * The channel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $channel;
    /**
     * The externalUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $externalUrl;
    /**
     * The orderLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XHistoricalOrderLine30[]
     */
    public $orderLine;
    /**
     * Constructor method for xHistoricalOrder30
     * @uses XHistoricalOrder30::setCustomerNo()
     * @uses XHistoricalOrder30::setOrderNumber()
     * @uses XHistoricalOrder30::setErpOrderReference()
     * @uses XHistoricalOrder30::setCustomerOrderReference()
     * @uses XHistoricalOrder30::setCollection()
     * @uses XHistoricalOrder30::setTimestamp()
     * @uses XHistoricalOrder30::setSalesPerson()
     * @uses XHistoricalOrder30::setCustomerPriceGroup()
     * @uses XHistoricalOrder30::setComment()
     * @uses XHistoricalOrder30::setShippingLocation()
     * @uses XHistoricalOrder30::setAgreement()
     * @uses XHistoricalOrder30::setChannel()
     * @uses XHistoricalOrder30::setExternalUrl()
     * @uses XHistoricalOrder30::setOrderLine()
     * @param string $customerNo
     * @param string $orderNumber
     * @param string $erpOrderReference
     * @param string $customerOrderReference
     * @param string $collection
     * @param string $timestamp
     * @param string $salesPerson
     * @param string $customerPriceGroup
     * @param string $comment
     * @param \ApptitudeNamespace\StructType\XLocation30 $shippingLocation
     * @param \ApptitudeNamespace\StructType\XAgreement30 $agreement
     * @param string $channel
     * @param string $externalUrl
     * @param \ApptitudeNamespace\StructType\XHistoricalOrderLine30[] $orderLine
     */
    public function __construct($customerNo = null, $orderNumber = null, $erpOrderReference = null, $customerOrderReference = null, $collection = null, $timestamp = null, $salesPerson = null, $customerPriceGroup = null, $comment = null, \ApptitudeNamespace\StructType\XLocation30 $shippingLocation = null, \ApptitudeNamespace\StructType\XAgreement30 $agreement = null, $channel = null, $externalUrl = null, array $orderLine = array())
    {
        $this
            ->setCustomerNo($customerNo)
            ->setOrderNumber($orderNumber)
            ->setErpOrderReference($erpOrderReference)
            ->setCustomerOrderReference($customerOrderReference)
            ->setCollection($collection)
            ->setTimestamp($timestamp)
            ->setSalesPerson($salesPerson)
            ->setCustomerPriceGroup($customerPriceGroup)
            ->setComment($comment)
            ->setShippingLocation($shippingLocation)
            ->setAgreement($agreement)
            ->setChannel($channel)
            ->setExternalUrl($externalUrl)
            ->setOrderLine($orderLine);
    }
    /**
     * Get customerNo value
     * @return string|null
     */
    public function getCustomerNo()
    {
        return $this->customerNo;
    }
    /**
     * Set customerNo value
     * @param string $customerNo
     * @return \ApptitudeNamespace\StructType\XHistoricalOrder30
     */
    public function setCustomerNo($customerNo = null)
    {
        // validation for constraint: string
        if (!is_null($customerNo) && !is_string($customerNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerNo)), __LINE__);
        }
        $this->customerNo = $customerNo;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \ApptitudeNamespace\StructType\XHistoricalOrder30
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get erpOrderReference value
     * @return string|null
     */
    public function getErpOrderReference()
    {
        return $this->erpOrderReference;
    }
    /**
     * Set erpOrderReference value
     * @param string $erpOrderReference
     * @return \ApptitudeNamespace\StructType\XHistoricalOrder30
     */
    public function setErpOrderReference($erpOrderReference = null)
    {
        // validation for constraint: string
        if (!is_null($erpOrderReference) && !is_string($erpOrderReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($erpOrderReference)), __LINE__);
        }
        $this->erpOrderReference = $erpOrderReference;
        return $this;
    }
    /**
     * Get customerOrderReference value
     * @return string|null
     */
    public function getCustomerOrderReference()
    {
        return $this->customerOrderReference;
    }
    /**
     * Set customerOrderReference value
     * @param string $customerOrderReference
     * @return \ApptitudeNamespace\StructType\XHistoricalOrder30
     */
    public function setCustomerOrderReference($customerOrderReference = null)
    {
        // validation for constraint: string
        if (!is_null($customerOrderReference) && !is_string($customerOrderReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerOrderReference)), __LINE__);
        }
        $this->customerOrderReference = $customerOrderReference;
        return $this;
    }
    /**
     * Get collection value
     * @return string|null
     */
    public function getCollection()
    {
        return $this->collection;
    }
    /**
     * Set collection value
     * @param string $collection
     * @return \ApptitudeNamespace\StructType\XHistoricalOrder30
     */
    public function setCollection($collection = null)
    {
        // validation for constraint: string
        if (!is_null($collection) && !is_string($collection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($collection)), __LINE__);
        }
        $this->collection = $collection;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \ApptitudeNamespace\StructType\XHistoricalOrder30
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get salesPerson value
     * @return string|null
     */
    public function getSalesPerson()
    {
        return $this->salesPerson;
    }
    /**
     * Set salesPerson value
     * @param string $salesPerson
     * @return \ApptitudeNamespace\StructType\XHistoricalOrder30
     */
    public function setSalesPerson($salesPerson = null)
    {
        // validation for constraint: string
        if (!is_null($salesPerson) && !is_string($salesPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesPerson)), __LINE__);
        }
        $this->salesPerson = $salesPerson;
        return $this;
    }
    /**
     * Get customerPriceGroup value
     * @return string|null
     */
    public function getCustomerPriceGroup()
    {
        return $this->customerPriceGroup;
    }
    /**
     * Set customerPriceGroup value
     * @param string $customerPriceGroup
     * @return \ApptitudeNamespace\StructType\XHistoricalOrder30
     */
    public function setCustomerPriceGroup($customerPriceGroup = null)
    {
        // validation for constraint: string
        if (!is_null($customerPriceGroup) && !is_string($customerPriceGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerPriceGroup)), __LINE__);
        }
        $this->customerPriceGroup = $customerPriceGroup;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \ApptitudeNamespace\StructType\XHistoricalOrder30
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get shippingLocation value
     * @return \ApptitudeNamespace\StructType\XLocation30|null
     */
    public function getShippingLocation()
    {
        return $this->shippingLocation;
    }
    /**
     * Set shippingLocation value
     * @param \ApptitudeNamespace\StructType\XLocation30 $shippingLocation
     * @return \ApptitudeNamespace\StructType\XHistoricalOrder30
     */
    public function setShippingLocation(\ApptitudeNamespace\StructType\XLocation30 $shippingLocation = null)
    {
        $this->shippingLocation = $shippingLocation;
        return $this;
    }
    /**
     * Get agreement value
     * @return \ApptitudeNamespace\StructType\XAgreement30|null
     */
    public function getAgreement()
    {
        return $this->agreement;
    }
    /**
     * Set agreement value
     * @param \ApptitudeNamespace\StructType\XAgreement30 $agreement
     * @return \ApptitudeNamespace\StructType\XHistoricalOrder30
     */
    public function setAgreement(\ApptitudeNamespace\StructType\XAgreement30 $agreement = null)
    {
        $this->agreement = $agreement;
        return $this;
    }
    /**
     * Get channel value
     * @return string|null
     */
    public function getChannel()
    {
        return $this->channel;
    }
    /**
     * Set channel value
     * @param string $channel
     * @return \ApptitudeNamespace\StructType\XHistoricalOrder30
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($channel)), __LINE__);
        }
        $this->channel = $channel;
        return $this;
    }
    /**
     * Get externalUrl value
     * @return string|null
     */
    public function getExternalUrl()
    {
        return $this->externalUrl;
    }
    /**
     * Set externalUrl value
     * @param string $externalUrl
     * @return \ApptitudeNamespace\StructType\XHistoricalOrder30
     */
    public function setExternalUrl($externalUrl = null)
    {
        // validation for constraint: string
        if (!is_null($externalUrl) && !is_string($externalUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalUrl)), __LINE__);
        }
        $this->externalUrl = $externalUrl;
        return $this;
    }
    /**
     * Get orderLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XHistoricalOrderLine30[]|null
     */
    public function getOrderLine()
    {
        return isset($this->orderLine) ? $this->orderLine : null;
    }
    /**
     * Set orderLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XHistoricalOrderLine30[] $orderLine
     * @return \ApptitudeNamespace\StructType\XHistoricalOrder30
     */
    public function setOrderLine(array $orderLine = array())
    {
        foreach ($orderLine as $xHistoricalOrder30OrderLineItem) {
            // validation for constraint: itemType
            if (!$xHistoricalOrder30OrderLineItem instanceof \ApptitudeNamespace\StructType\XHistoricalOrderLine30) {
                throw new \InvalidArgumentException(sprintf('The orderLine property can only contain items of \ApptitudeNamespace\StructType\XHistoricalOrderLine30, "%s" given', is_object($xHistoricalOrder30OrderLineItem) ? get_class($xHistoricalOrder30OrderLineItem) : gettype($xHistoricalOrder30OrderLineItem)), __LINE__);
            }
        }
        if (is_null($orderLine) || (is_array($orderLine) && empty($orderLine))) {
            unset($this->orderLine);
        } else {
            $this->orderLine = $orderLine;
        }
        return $this;
    }
    /**
     * Add item to orderLine value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XHistoricalOrderLine30 $item
     * @return \ApptitudeNamespace\StructType\XHistoricalOrder30
     */
    public function addToOrderLine(\ApptitudeNamespace\StructType\XHistoricalOrderLine30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XHistoricalOrderLine30) {
            throw new \InvalidArgumentException(sprintf('The orderLine property can only contain items of \ApptitudeNamespace\StructType\XHistoricalOrderLine30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderLine[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\XHistoricalOrder30
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
