<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xCustomer30 StructType
 * @subpackage Structs
 */
class XCustomer30 extends XObject30
{
    /**
     * The customerNo
     * @var string
     */
    public $customerNo;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The searchName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchName;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The street
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $street;
    /**
     * The houseNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $houseNumber;
    /**
     * The houseNumberSuffix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $houseNumberSuffix;
    /**
     * The postalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postalCode;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The phone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The activePriceGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $activePriceGroup;
    /**
     * The nextPriceGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nextPriceGroup;
    /**
     * The nextPriceGroupDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nextPriceGroupDate;
    /**
     * The currencyCode
     * @var string
     */
    public $currencyCode;
    /**
     * The shippingLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XLocation30[]
     */
    public $shippingLocation;
    /**
     * The orderFooter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderFooter;
    /**
     * The language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * The channel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $channel;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The statusMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $statusMessage;
    /**
     * The contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XContact30[]
     */
    public $contact;
    /**
     * The marginGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XMarginGroup30[]
     */
    public $marginGroup;
    /**
     * The discountGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XDiscountGroup30[]
     */
    public $discountGroup;
    /**
     * The budgetComponent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XBudgetComponent30[]
     */
    public $budgetComponent;
    /**
     * The userDefinedField
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userDefinedField;
    /**
     * The agreement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XAgreement30[]
     */
    public $agreement;
    /**
     * The customChoice
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XCustomChoice30[]
     */
    public $customChoice;
    /**
     * The maxOrderValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $maxOrderValue;
    /**
     * The orderDiscountRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XOrderAmountModificationRule30[]
     */
    public $orderDiscountRule;
    /**
     * The orderDeliveryCostRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XOrderAmountModificationRule30[]
     */
    public $orderDeliveryCostRule;
    /**
     * The shippingTime
     * @var int
     */
    public $shippingTime;
    /**
     * The extraField
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XExtraField30[]
     */
    public $extraField;
    /**
     * The sizeAccessCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $sizeAccessCode;
    /**
     * The minimumQuantitiesKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $minimumQuantitiesKey;
    /**
     * Constructor method for xCustomer30
     * @uses XCustomer30::setCustomerNo()
     * @uses XCustomer30::setName()
     * @uses XCustomer30::setEmail()
     * @uses XCustomer30::setSearchName()
     * @uses XCustomer30::setAddress()
     * @uses XCustomer30::setStreet()
     * @uses XCustomer30::setHouseNumber()
     * @uses XCustomer30::setHouseNumberSuffix()
     * @uses XCustomer30::setPostalCode()
     * @uses XCustomer30::setCity()
     * @uses XCustomer30::setCountry()
     * @uses XCustomer30::setPhone()
     * @uses XCustomer30::setActivePriceGroup()
     * @uses XCustomer30::setNextPriceGroup()
     * @uses XCustomer30::setNextPriceGroupDate()
     * @uses XCustomer30::setCurrencyCode()
     * @uses XCustomer30::setShippingLocation()
     * @uses XCustomer30::setOrderFooter()
     * @uses XCustomer30::setLanguage()
     * @uses XCustomer30::setChannel()
     * @uses XCustomer30::setStatus()
     * @uses XCustomer30::setStatusMessage()
     * @uses XCustomer30::setContact()
     * @uses XCustomer30::setMarginGroup()
     * @uses XCustomer30::setDiscountGroup()
     * @uses XCustomer30::setBudgetComponent()
     * @uses XCustomer30::setUserDefinedField()
     * @uses XCustomer30::setAgreement()
     * @uses XCustomer30::setCustomChoice()
     * @uses XCustomer30::setMaxOrderValue()
     * @uses XCustomer30::setOrderDiscountRule()
     * @uses XCustomer30::setOrderDeliveryCostRule()
     * @uses XCustomer30::setShippingTime()
     * @uses XCustomer30::setExtraField()
     * @uses XCustomer30::setSizeAccessCode()
     * @uses XCustomer30::setMinimumQuantitiesKey()
     * @param string $customerNo
     * @param string $name
     * @param string $email
     * @param string $searchName
     * @param string $address
     * @param string $street
     * @param string $houseNumber
     * @param string $houseNumberSuffix
     * @param string $postalCode
     * @param string $city
     * @param string $country
     * @param string $phone
     * @param string $activePriceGroup
     * @param string $nextPriceGroup
     * @param string $nextPriceGroupDate
     * @param string $currencyCode
     * @param \ApptitudeNamespace\StructType\XLocation30[] $shippingLocation
     * @param string $orderFooter
     * @param string $language
     * @param string $channel
     * @param string $status
     * @param string $statusMessage
     * @param \ApptitudeNamespace\StructType\XContact30[] $contact
     * @param \ApptitudeNamespace\StructType\XMarginGroup30[] $marginGroup
     * @param \ApptitudeNamespace\StructType\XDiscountGroup30[] $discountGroup
     * @param \ApptitudeNamespace\StructType\XBudgetComponent30[] $budgetComponent
     * @param string $userDefinedField
     * @param \ApptitudeNamespace\StructType\XAgreement30[] $agreement
     * @param \ApptitudeNamespace\StructType\XCustomChoice30[] $customChoice
     * @param float $maxOrderValue
     * @param \ApptitudeNamespace\StructType\XOrderAmountModificationRule30[] $orderDiscountRule
     * @param \ApptitudeNamespace\StructType\XOrderAmountModificationRule30[] $orderDeliveryCostRule
     * @param int $shippingTime
     * @param \ApptitudeNamespace\StructType\XExtraField30[] $extraField
     * @param string[] $sizeAccessCode
     * @param string $minimumQuantitiesKey
     */
    public function __construct($customerNo = null, $name = null, $email = null, $searchName = null, $address = null, $street = null, $houseNumber = null, $houseNumberSuffix = null, $postalCode = null, $city = null, $country = null, $phone = null, $activePriceGroup = null, $nextPriceGroup = null, $nextPriceGroupDate = null, $currencyCode = null, array $shippingLocation = array(), $orderFooter = null, $language = null, $channel = null, $status = null, $statusMessage = null, array $contact = array(), array $marginGroup = array(), array $discountGroup = array(), array $budgetComponent = array(), $userDefinedField = null, array $agreement = array(), array $customChoice = array(), $maxOrderValue = null, array $orderDiscountRule = array(), array $orderDeliveryCostRule = array(), $shippingTime = null, array $extraField = array(), array $sizeAccessCode = array(), $minimumQuantitiesKey = null)
    {
        $this
            ->setCustomerNo($customerNo)
            ->setName($name)
            ->setEmail($email)
            ->setSearchName($searchName)
            ->setAddress($address)
            ->setStreet($street)
            ->setHouseNumber($houseNumber)
            ->setHouseNumberSuffix($houseNumberSuffix)
            ->setPostalCode($postalCode)
            ->setCity($city)
            ->setCountry($country)
            ->setPhone($phone)
            ->setActivePriceGroup($activePriceGroup)
            ->setNextPriceGroup($nextPriceGroup)
            ->setNextPriceGroupDate($nextPriceGroupDate)
            ->setCurrencyCode($currencyCode)
            ->setShippingLocation($shippingLocation)
            ->setOrderFooter($orderFooter)
            ->setLanguage($language)
            ->setChannel($channel)
            ->setStatus($status)
            ->setStatusMessage($statusMessage)
            ->setContact($contact)
            ->setMarginGroup($marginGroup)
            ->setDiscountGroup($discountGroup)
            ->setBudgetComponent($budgetComponent)
            ->setUserDefinedField($userDefinedField)
            ->setAgreement($agreement)
            ->setCustomChoice($customChoice)
            ->setMaxOrderValue($maxOrderValue)
            ->setOrderDiscountRule($orderDiscountRule)
            ->setOrderDeliveryCostRule($orderDeliveryCostRule)
            ->setShippingTime($shippingTime)
            ->setExtraField($extraField)
            ->setSizeAccessCode($sizeAccessCode)
            ->setMinimumQuantitiesKey($minimumQuantitiesKey);
    }
    /**
     * Get customerNo value
     * @return string|null
     */
    public function getCustomerNo()
    {
        return $this->customerNo;
    }
    /**
     * Set customerNo value
     * @param string $customerNo
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setCustomerNo($customerNo = null)
    {
        // validation for constraint: string
        if (!is_null($customerNo) && !is_string($customerNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerNo)), __LINE__);
        }
        $this->customerNo = $customerNo;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get searchName value
     * @return string|null
     */
    public function getSearchName()
    {
        return $this->searchName;
    }
    /**
     * Set searchName value
     * @param string $searchName
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setSearchName($searchName = null)
    {
        // validation for constraint: string
        if (!is_null($searchName) && !is_string($searchName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchName)), __LINE__);
        }
        $this->searchName = $searchName;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($houseNumber)), __LINE__);
        }
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get houseNumberSuffix value
     * @return string|null
     */
    public function getHouseNumberSuffix()
    {
        return $this->houseNumberSuffix;
    }
    /**
     * Set houseNumberSuffix value
     * @param string $houseNumberSuffix
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setHouseNumberSuffix($houseNumberSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumberSuffix) && !is_string($houseNumberSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($houseNumberSuffix)), __LINE__);
        }
        $this->houseNumberSuffix = $houseNumberSuffix;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get activePriceGroup value
     * @return string|null
     */
    public function getActivePriceGroup()
    {
        return $this->activePriceGroup;
    }
    /**
     * Set activePriceGroup value
     * @param string $activePriceGroup
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setActivePriceGroup($activePriceGroup = null)
    {
        // validation for constraint: string
        if (!is_null($activePriceGroup) && !is_string($activePriceGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activePriceGroup)), __LINE__);
        }
        $this->activePriceGroup = $activePriceGroup;
        return $this;
    }
    /**
     * Get nextPriceGroup value
     * @return string|null
     */
    public function getNextPriceGroup()
    {
        return $this->nextPriceGroup;
    }
    /**
     * Set nextPriceGroup value
     * @param string $nextPriceGroup
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setNextPriceGroup($nextPriceGroup = null)
    {
        // validation for constraint: string
        if (!is_null($nextPriceGroup) && !is_string($nextPriceGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextPriceGroup)), __LINE__);
        }
        $this->nextPriceGroup = $nextPriceGroup;
        return $this;
    }
    /**
     * Get nextPriceGroupDate value
     * @return string|null
     */
    public function getNextPriceGroupDate()
    {
        return $this->nextPriceGroupDate;
    }
    /**
     * Set nextPriceGroupDate value
     * @param string $nextPriceGroupDate
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setNextPriceGroupDate($nextPriceGroupDate = null)
    {
        // validation for constraint: string
        if (!is_null($nextPriceGroupDate) && !is_string($nextPriceGroupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextPriceGroupDate)), __LINE__);
        }
        $this->nextPriceGroupDate = $nextPriceGroupDate;
        return $this;
    }
    /**
     * Get currencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }
    /**
     * Set currencyCode value
     * @param string $currencyCode
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->currencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get shippingLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XLocation30[]|null
     */
    public function getShippingLocation()
    {
        return isset($this->shippingLocation) ? $this->shippingLocation : null;
    }
    /**
     * Set shippingLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XLocation30[] $shippingLocation
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setShippingLocation(array $shippingLocation = array())
    {
        foreach ($shippingLocation as $xCustomer30ShippingLocationItem) {
            // validation for constraint: itemType
            if (!$xCustomer30ShippingLocationItem instanceof \ApptitudeNamespace\StructType\XLocation30) {
                throw new \InvalidArgumentException(sprintf('The shippingLocation property can only contain items of \ApptitudeNamespace\StructType\XLocation30, "%s" given', is_object($xCustomer30ShippingLocationItem) ? get_class($xCustomer30ShippingLocationItem) : gettype($xCustomer30ShippingLocationItem)), __LINE__);
            }
        }
        if (is_null($shippingLocation) || (is_array($shippingLocation) && empty($shippingLocation))) {
            unset($this->shippingLocation);
        } else {
            $this->shippingLocation = $shippingLocation;
        }
        return $this;
    }
    /**
     * Add item to shippingLocation value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XLocation30 $item
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function addToShippingLocation(\ApptitudeNamespace\StructType\XLocation30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XLocation30) {
            throw new \InvalidArgumentException(sprintf('The shippingLocation property can only contain items of \ApptitudeNamespace\StructType\XLocation30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->shippingLocation[] = $item;
        return $this;
    }
    /**
     * Get orderFooter value
     * @return string|null
     */
    public function getOrderFooter()
    {
        return $this->orderFooter;
    }
    /**
     * Set orderFooter value
     * @param string $orderFooter
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setOrderFooter($orderFooter = null)
    {
        // validation for constraint: string
        if (!is_null($orderFooter) && !is_string($orderFooter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderFooter)), __LINE__);
        }
        $this->orderFooter = $orderFooter;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get channel value
     * @return string|null
     */
    public function getChannel()
    {
        return $this->channel;
    }
    /**
     * Set channel value
     * @param string $channel
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($channel)), __LINE__);
        }
        $this->channel = $channel;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \ApptitudeNamespace\EnumType\XCustomerStatus30::valueIsValid()
     * @uses \ApptitudeNamespace\EnumType\XCustomerStatus30::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\ApptitudeNamespace\EnumType\XCustomerStatus30::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \ApptitudeNamespace\EnumType\XCustomerStatus30::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get statusMessage value
     * @return string|null
     */
    public function getStatusMessage()
    {
        return $this->statusMessage;
    }
    /**
     * Set statusMessage value
     * @param string $statusMessage
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setStatusMessage($statusMessage = null)
    {
        // validation for constraint: string
        if (!is_null($statusMessage) && !is_string($statusMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusMessage)), __LINE__);
        }
        $this->statusMessage = $statusMessage;
        return $this;
    }
    /**
     * Get contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XContact30[]|null
     */
    public function getContact()
    {
        return isset($this->contact) ? $this->contact : null;
    }
    /**
     * Set contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XContact30[] $contact
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setContact(array $contact = array())
    {
        foreach ($contact as $xCustomer30ContactItem) {
            // validation for constraint: itemType
            if (!$xCustomer30ContactItem instanceof \ApptitudeNamespace\StructType\XContact30) {
                throw new \InvalidArgumentException(sprintf('The contact property can only contain items of \ApptitudeNamespace\StructType\XContact30, "%s" given', is_object($xCustomer30ContactItem) ? get_class($xCustomer30ContactItem) : gettype($xCustomer30ContactItem)), __LINE__);
            }
        }
        if (is_null($contact) || (is_array($contact) && empty($contact))) {
            unset($this->contact);
        } else {
            $this->contact = $contact;
        }
        return $this;
    }
    /**
     * Add item to contact value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XContact30 $item
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function addToContact(\ApptitudeNamespace\StructType\XContact30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XContact30) {
            throw new \InvalidArgumentException(sprintf('The contact property can only contain items of \ApptitudeNamespace\StructType\XContact30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->contact[] = $item;
        return $this;
    }
    /**
     * Get marginGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XMarginGroup30[]|null
     */
    public function getMarginGroup()
    {
        return isset($this->marginGroup) ? $this->marginGroup : null;
    }
    /**
     * Set marginGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XMarginGroup30[] $marginGroup
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setMarginGroup(array $marginGroup = array())
    {
        foreach ($marginGroup as $xCustomer30MarginGroupItem) {
            // validation for constraint: itemType
            if (!$xCustomer30MarginGroupItem instanceof \ApptitudeNamespace\StructType\XMarginGroup30) {
                throw new \InvalidArgumentException(sprintf('The marginGroup property can only contain items of \ApptitudeNamespace\StructType\XMarginGroup30, "%s" given', is_object($xCustomer30MarginGroupItem) ? get_class($xCustomer30MarginGroupItem) : gettype($xCustomer30MarginGroupItem)), __LINE__);
            }
        }
        if (is_null($marginGroup) || (is_array($marginGroup) && empty($marginGroup))) {
            unset($this->marginGroup);
        } else {
            $this->marginGroup = $marginGroup;
        }
        return $this;
    }
    /**
     * Add item to marginGroup value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XMarginGroup30 $item
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function addToMarginGroup(\ApptitudeNamespace\StructType\XMarginGroup30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XMarginGroup30) {
            throw new \InvalidArgumentException(sprintf('The marginGroup property can only contain items of \ApptitudeNamespace\StructType\XMarginGroup30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->marginGroup[] = $item;
        return $this;
    }
    /**
     * Get discountGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XDiscountGroup30[]|null
     */
    public function getDiscountGroup()
    {
        return isset($this->discountGroup) ? $this->discountGroup : null;
    }
    /**
     * Set discountGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XDiscountGroup30[] $discountGroup
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setDiscountGroup(array $discountGroup = array())
    {
        foreach ($discountGroup as $xCustomer30DiscountGroupItem) {
            // validation for constraint: itemType
            if (!$xCustomer30DiscountGroupItem instanceof \ApptitudeNamespace\StructType\XDiscountGroup30) {
                throw new \InvalidArgumentException(sprintf('The discountGroup property can only contain items of \ApptitudeNamespace\StructType\XDiscountGroup30, "%s" given', is_object($xCustomer30DiscountGroupItem) ? get_class($xCustomer30DiscountGroupItem) : gettype($xCustomer30DiscountGroupItem)), __LINE__);
            }
        }
        if (is_null($discountGroup) || (is_array($discountGroup) && empty($discountGroup))) {
            unset($this->discountGroup);
        } else {
            $this->discountGroup = $discountGroup;
        }
        return $this;
    }
    /**
     * Add item to discountGroup value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XDiscountGroup30 $item
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function addToDiscountGroup(\ApptitudeNamespace\StructType\XDiscountGroup30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XDiscountGroup30) {
            throw new \InvalidArgumentException(sprintf('The discountGroup property can only contain items of \ApptitudeNamespace\StructType\XDiscountGroup30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->discountGroup[] = $item;
        return $this;
    }
    /**
     * Get budgetComponent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XBudgetComponent30[]|null
     */
    public function getBudgetComponent()
    {
        return isset($this->budgetComponent) ? $this->budgetComponent : null;
    }
    /**
     * Set budgetComponent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XBudgetComponent30[] $budgetComponent
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setBudgetComponent(array $budgetComponent = array())
    {
        foreach ($budgetComponent as $xCustomer30BudgetComponentItem) {
            // validation for constraint: itemType
            if (!$xCustomer30BudgetComponentItem instanceof \ApptitudeNamespace\StructType\XBudgetComponent30) {
                throw new \InvalidArgumentException(sprintf('The budgetComponent property can only contain items of \ApptitudeNamespace\StructType\XBudgetComponent30, "%s" given', is_object($xCustomer30BudgetComponentItem) ? get_class($xCustomer30BudgetComponentItem) : gettype($xCustomer30BudgetComponentItem)), __LINE__);
            }
        }
        if (is_null($budgetComponent) || (is_array($budgetComponent) && empty($budgetComponent))) {
            unset($this->budgetComponent);
        } else {
            $this->budgetComponent = $budgetComponent;
        }
        return $this;
    }
    /**
     * Add item to budgetComponent value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XBudgetComponent30 $item
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function addToBudgetComponent(\ApptitudeNamespace\StructType\XBudgetComponent30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XBudgetComponent30) {
            throw new \InvalidArgumentException(sprintf('The budgetComponent property can only contain items of \ApptitudeNamespace\StructType\XBudgetComponent30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->budgetComponent[] = $item;
        return $this;
    }
    /**
     * Get userDefinedField value
     * @return string|null
     */
    public function getUserDefinedField()
    {
        return $this->userDefinedField;
    }
    /**
     * Set userDefinedField value
     * @param string $userDefinedField
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setUserDefinedField($userDefinedField = null)
    {
        // validation for constraint: string
        if (!is_null($userDefinedField) && !is_string($userDefinedField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userDefinedField)), __LINE__);
        }
        $this->userDefinedField = $userDefinedField;
        return $this;
    }
    /**
     * Get agreement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XAgreement30[]|null
     */
    public function getAgreement()
    {
        return isset($this->agreement) ? $this->agreement : null;
    }
    /**
     * Set agreement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XAgreement30[] $agreement
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setAgreement(array $agreement = array())
    {
        foreach ($agreement as $xCustomer30AgreementItem) {
            // validation for constraint: itemType
            if (!$xCustomer30AgreementItem instanceof \ApptitudeNamespace\StructType\XAgreement30) {
                throw new \InvalidArgumentException(sprintf('The agreement property can only contain items of \ApptitudeNamespace\StructType\XAgreement30, "%s" given', is_object($xCustomer30AgreementItem) ? get_class($xCustomer30AgreementItem) : gettype($xCustomer30AgreementItem)), __LINE__);
            }
        }
        if (is_null($agreement) || (is_array($agreement) && empty($agreement))) {
            unset($this->agreement);
        } else {
            $this->agreement = $agreement;
        }
        return $this;
    }
    /**
     * Add item to agreement value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XAgreement30 $item
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function addToAgreement(\ApptitudeNamespace\StructType\XAgreement30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XAgreement30) {
            throw new \InvalidArgumentException(sprintf('The agreement property can only contain items of \ApptitudeNamespace\StructType\XAgreement30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->agreement[] = $item;
        return $this;
    }
    /**
     * Get customChoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XCustomChoice30[]|null
     */
    public function getCustomChoice()
    {
        return isset($this->customChoice) ? $this->customChoice : null;
    }
    /**
     * Set customChoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XCustomChoice30[] $customChoice
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setCustomChoice(array $customChoice = array())
    {
        foreach ($customChoice as $xCustomer30CustomChoiceItem) {
            // validation for constraint: itemType
            if (!$xCustomer30CustomChoiceItem instanceof \ApptitudeNamespace\StructType\XCustomChoice30) {
                throw new \InvalidArgumentException(sprintf('The customChoice property can only contain items of \ApptitudeNamespace\StructType\XCustomChoice30, "%s" given', is_object($xCustomer30CustomChoiceItem) ? get_class($xCustomer30CustomChoiceItem) : gettype($xCustomer30CustomChoiceItem)), __LINE__);
            }
        }
        if (is_null($customChoice) || (is_array($customChoice) && empty($customChoice))) {
            unset($this->customChoice);
        } else {
            $this->customChoice = $customChoice;
        }
        return $this;
    }
    /**
     * Add item to customChoice value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XCustomChoice30 $item
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function addToCustomChoice(\ApptitudeNamespace\StructType\XCustomChoice30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XCustomChoice30) {
            throw new \InvalidArgumentException(sprintf('The customChoice property can only contain items of \ApptitudeNamespace\StructType\XCustomChoice30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->customChoice[] = $item;
        return $this;
    }
    /**
     * Get maxOrderValue value
     * @return float|null
     */
    public function getMaxOrderValue()
    {
        return $this->maxOrderValue;
    }
    /**
     * Set maxOrderValue value
     * @param float $maxOrderValue
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setMaxOrderValue($maxOrderValue = null)
    {
        $this->maxOrderValue = $maxOrderValue;
        return $this;
    }
    /**
     * Get orderDiscountRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XOrderAmountModificationRule30[]|null
     */
    public function getOrderDiscountRule()
    {
        return isset($this->orderDiscountRule) ? $this->orderDiscountRule : null;
    }
    /**
     * Set orderDiscountRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XOrderAmountModificationRule30[] $orderDiscountRule
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setOrderDiscountRule(array $orderDiscountRule = array())
    {
        foreach ($orderDiscountRule as $xCustomer30OrderDiscountRuleItem) {
            // validation for constraint: itemType
            if (!$xCustomer30OrderDiscountRuleItem instanceof \ApptitudeNamespace\StructType\XOrderAmountModificationRule30) {
                throw new \InvalidArgumentException(sprintf('The orderDiscountRule property can only contain items of \ApptitudeNamespace\StructType\XOrderAmountModificationRule30, "%s" given', is_object($xCustomer30OrderDiscountRuleItem) ? get_class($xCustomer30OrderDiscountRuleItem) : gettype($xCustomer30OrderDiscountRuleItem)), __LINE__);
            }
        }
        if (is_null($orderDiscountRule) || (is_array($orderDiscountRule) && empty($orderDiscountRule))) {
            unset($this->orderDiscountRule);
        } else {
            $this->orderDiscountRule = $orderDiscountRule;
        }
        return $this;
    }
    /**
     * Add item to orderDiscountRule value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XOrderAmountModificationRule30 $item
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function addToOrderDiscountRule(\ApptitudeNamespace\StructType\XOrderAmountModificationRule30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XOrderAmountModificationRule30) {
            throw new \InvalidArgumentException(sprintf('The orderDiscountRule property can only contain items of \ApptitudeNamespace\StructType\XOrderAmountModificationRule30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderDiscountRule[] = $item;
        return $this;
    }
    /**
     * Get orderDeliveryCostRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XOrderAmountModificationRule30[]|null
     */
    public function getOrderDeliveryCostRule()
    {
        return isset($this->orderDeliveryCostRule) ? $this->orderDeliveryCostRule : null;
    }
    /**
     * Set orderDeliveryCostRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XOrderAmountModificationRule30[] $orderDeliveryCostRule
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setOrderDeliveryCostRule(array $orderDeliveryCostRule = array())
    {
        foreach ($orderDeliveryCostRule as $xCustomer30OrderDeliveryCostRuleItem) {
            // validation for constraint: itemType
            if (!$xCustomer30OrderDeliveryCostRuleItem instanceof \ApptitudeNamespace\StructType\XOrderAmountModificationRule30) {
                throw new \InvalidArgumentException(sprintf('The orderDeliveryCostRule property can only contain items of \ApptitudeNamespace\StructType\XOrderAmountModificationRule30, "%s" given', is_object($xCustomer30OrderDeliveryCostRuleItem) ? get_class($xCustomer30OrderDeliveryCostRuleItem) : gettype($xCustomer30OrderDeliveryCostRuleItem)), __LINE__);
            }
        }
        if (is_null($orderDeliveryCostRule) || (is_array($orderDeliveryCostRule) && empty($orderDeliveryCostRule))) {
            unset($this->orderDeliveryCostRule);
        } else {
            $this->orderDeliveryCostRule = $orderDeliveryCostRule;
        }
        return $this;
    }
    /**
     * Add item to orderDeliveryCostRule value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XOrderAmountModificationRule30 $item
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function addToOrderDeliveryCostRule(\ApptitudeNamespace\StructType\XOrderAmountModificationRule30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XOrderAmountModificationRule30) {
            throw new \InvalidArgumentException(sprintf('The orderDeliveryCostRule property can only contain items of \ApptitudeNamespace\StructType\XOrderAmountModificationRule30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderDeliveryCostRule[] = $item;
        return $this;
    }
    /**
     * Get shippingTime value
     * @return int|null
     */
    public function getShippingTime()
    {
        return $this->shippingTime;
    }
    /**
     * Set shippingTime value
     * @param int $shippingTime
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setShippingTime($shippingTime = null)
    {
        // validation for constraint: int
        if (!is_null($shippingTime) && !is_numeric($shippingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($shippingTime)), __LINE__);
        }
        $this->shippingTime = $shippingTime;
        return $this;
    }
    /**
     * Get extraField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XExtraField30[]|null
     */
    public function getExtraField()
    {
        return isset($this->extraField) ? $this->extraField : null;
    }
    /**
     * Set extraField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XExtraField30[] $extraField
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setExtraField(array $extraField = array())
    {
        foreach ($extraField as $xCustomer30ExtraFieldItem) {
            // validation for constraint: itemType
            if (!$xCustomer30ExtraFieldItem instanceof \ApptitudeNamespace\StructType\XExtraField30) {
                throw new \InvalidArgumentException(sprintf('The extraField property can only contain items of \ApptitudeNamespace\StructType\XExtraField30, "%s" given', is_object($xCustomer30ExtraFieldItem) ? get_class($xCustomer30ExtraFieldItem) : gettype($xCustomer30ExtraFieldItem)), __LINE__);
            }
        }
        if (is_null($extraField) || (is_array($extraField) && empty($extraField))) {
            unset($this->extraField);
        } else {
            $this->extraField = $extraField;
        }
        return $this;
    }
    /**
     * Add item to extraField value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XExtraField30 $item
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function addToExtraField(\ApptitudeNamespace\StructType\XExtraField30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XExtraField30) {
            throw new \InvalidArgumentException(sprintf('The extraField property can only contain items of \ApptitudeNamespace\StructType\XExtraField30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->extraField[] = $item;
        return $this;
    }
    /**
     * Get sizeAccessCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getSizeAccessCode()
    {
        return isset($this->sizeAccessCode) ? $this->sizeAccessCode : null;
    }
    /**
     * Set sizeAccessCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $sizeAccessCode
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setSizeAccessCode(array $sizeAccessCode = array())
    {
        foreach ($sizeAccessCode as $xCustomer30SizeAccessCodeItem) {
            // validation for constraint: itemType
            if (!is_string($xCustomer30SizeAccessCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The sizeAccessCode property can only contain items of string, "%s" given', is_object($xCustomer30SizeAccessCodeItem) ? get_class($xCustomer30SizeAccessCodeItem) : gettype($xCustomer30SizeAccessCodeItem)), __LINE__);
            }
        }
        if (is_null($sizeAccessCode) || (is_array($sizeAccessCode) && empty($sizeAccessCode))) {
            unset($this->sizeAccessCode);
        } else {
            $this->sizeAccessCode = $sizeAccessCode;
        }
        return $this;
    }
    /**
     * Add item to sizeAccessCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function addToSizeAccessCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The sizeAccessCode property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->sizeAccessCode[] = $item;
        return $this;
    }
    /**
     * Get minimumQuantitiesKey value
     * @return string|null
     */
    public function getMinimumQuantitiesKey()
    {
        return $this->minimumQuantitiesKey;
    }
    /**
     * Set minimumQuantitiesKey value
     * @param string $minimumQuantitiesKey
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public function setMinimumQuantitiesKey($minimumQuantitiesKey = null)
    {
        // validation for constraint: string
        if (!is_null($minimumQuantitiesKey) && !is_string($minimumQuantitiesKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minimumQuantitiesKey)), __LINE__);
        }
        $this->minimumQuantitiesKey = $minimumQuantitiesKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\XCustomer30
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
