<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xCustomChoice30 StructType
 * @subpackage Structs
 */
class XCustomChoice30 extends XObject30
{
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * The group
     * @var string
     */
    public $group;
    /**
     * The sortCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sortCode;
    /**
     * The defaultChoice
     * @var bool
     */
    public $defaultChoice;
    /**
     * The userType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $userType;
    /**
     * Constructor method for xCustomChoice30
     * @uses XCustomChoice30::setCode()
     * @uses XCustomChoice30::setValue()
     * @uses XCustomChoice30::setGroup()
     * @uses XCustomChoice30::setSortCode()
     * @uses XCustomChoice30::setDefaultChoice()
     * @uses XCustomChoice30::setUserType()
     * @param string $code
     * @param string $value
     * @param string $group
     * @param int $sortCode
     * @param bool $defaultChoice
     * @param string[] $userType
     */
    public function __construct($code = null, $value = null, $group = null, $sortCode = null, $defaultChoice = null, array $userType = array())
    {
        $this
            ->setCode($code)
            ->setValue($value)
            ->setGroup($group)
            ->setSortCode($sortCode)
            ->setDefaultChoice($defaultChoice)
            ->setUserType($userType);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \ApptitudeNamespace\StructType\XCustomChoice30
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \ApptitudeNamespace\StructType\XCustomChoice30
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get group value
     * @return string|null
     */
    public function getGroup()
    {
        return $this->group;
    }
    /**
     * Set group value
     * @param string $group
     * @return \ApptitudeNamespace\StructType\XCustomChoice30
     */
    public function setGroup($group = null)
    {
        // validation for constraint: string
        if (!is_null($group) && !is_string($group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($group)), __LINE__);
        }
        $this->group = $group;
        return $this;
    }
    /**
     * Get sortCode value
     * @return int|null
     */
    public function getSortCode()
    {
        return $this->sortCode;
    }
    /**
     * Set sortCode value
     * @param int $sortCode
     * @return \ApptitudeNamespace\StructType\XCustomChoice30
     */
    public function setSortCode($sortCode = null)
    {
        // validation for constraint: int
        if (!is_null($sortCode) && !is_numeric($sortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortCode)), __LINE__);
        }
        $this->sortCode = $sortCode;
        return $this;
    }
    /**
     * Get defaultChoice value
     * @return bool|null
     */
    public function getDefaultChoice()
    {
        return $this->defaultChoice;
    }
    /**
     * Set defaultChoice value
     * @param bool $defaultChoice
     * @return \ApptitudeNamespace\StructType\XCustomChoice30
     */
    public function setDefaultChoice($defaultChoice = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultChoice) && !is_bool($defaultChoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($defaultChoice)), __LINE__);
        }
        $this->defaultChoice = $defaultChoice;
        return $this;
    }
    /**
     * Get userType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getUserType()
    {
        return isset($this->userType) ? $this->userType : null;
    }
    /**
     * Set userType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \ApptitudeNamespace\EnumType\XUserType30::valueIsValid()
     * @uses \ApptitudeNamespace\EnumType\XUserType30::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $userType
     * @return \ApptitudeNamespace\StructType\XCustomChoice30
     */
    public function setUserType(array $userType = array())
    {
        $invalidValues = array();
        foreach ($userType as $xCustomChoice30UserTypeItem) {
            if (!\ApptitudeNamespace\EnumType\XUserType30::valueIsValid($xCustomChoice30UserTypeItem)) {
                $invalidValues[] = var_export($xCustomChoice30UserTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \ApptitudeNamespace\EnumType\XUserType30::getValidValues())), __LINE__);
        }
        if (is_null($userType) || (is_array($userType) && empty($userType))) {
            unset($this->userType);
        } else {
            $this->userType = $userType;
        }
        return $this;
    }
    /**
     * Add item to userType value
     * @uses \ApptitudeNamespace\EnumType\XUserType30::valueIsValid()
     * @uses \ApptitudeNamespace\EnumType\XUserType30::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ApptitudeNamespace\StructType\XCustomChoice30
     */
    public function addToUserType($item)
    {
        // validation for constraint: enumeration
        if (!\ApptitudeNamespace\EnumType\XUserType30::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \ApptitudeNamespace\EnumType\XUserType30::getValidValues())), __LINE__);
        }
        $this->userType[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\XCustomChoice30
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
