<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xAgreement30 StructType
 * @subpackage Structs
 */
class XAgreement30 extends XObject30
{
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The channel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $channel;
    /**
     * The activePriceGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $activePriceGroup;
    /**
     * The nextPriceGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nextPriceGroup;
    /**
     * The nextPriceGroupDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nextPriceGroupDate;
    /**
     * The currencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currencyCode;
    /**
     * The marginGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XMarginGroup30[]
     */
    public $marginGroup;
    /**
     * The discountGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XDiscountGroup30[]
     */
    public $discountGroup;
    /**
     * The orderFooter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderFooter;
    /**
     * Constructor method for xAgreement30
     * @uses XAgreement30::setCode()
     * @uses XAgreement30::setDescription()
     * @uses XAgreement30::setChannel()
     * @uses XAgreement30::setActivePriceGroup()
     * @uses XAgreement30::setNextPriceGroup()
     * @uses XAgreement30::setNextPriceGroupDate()
     * @uses XAgreement30::setCurrencyCode()
     * @uses XAgreement30::setMarginGroup()
     * @uses XAgreement30::setDiscountGroup()
     * @uses XAgreement30::setOrderFooter()
     * @param string $code
     * @param string $description
     * @param string $channel
     * @param string $activePriceGroup
     * @param string $nextPriceGroup
     * @param string $nextPriceGroupDate
     * @param string $currencyCode
     * @param \ApptitudeNamespace\StructType\XMarginGroup30[] $marginGroup
     * @param \ApptitudeNamespace\StructType\XDiscountGroup30[] $discountGroup
     * @param string $orderFooter
     */
    public function __construct($code = null, $description = null, $channel = null, $activePriceGroup = null, $nextPriceGroup = null, $nextPriceGroupDate = null, $currencyCode = null, array $marginGroup = array(), array $discountGroup = array(), $orderFooter = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setChannel($channel)
            ->setActivePriceGroup($activePriceGroup)
            ->setNextPriceGroup($nextPriceGroup)
            ->setNextPriceGroupDate($nextPriceGroupDate)
            ->setCurrencyCode($currencyCode)
            ->setMarginGroup($marginGroup)
            ->setDiscountGroup($discountGroup)
            ->setOrderFooter($orderFooter);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \ApptitudeNamespace\StructType\XAgreement30
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \ApptitudeNamespace\StructType\XAgreement30
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get channel value
     * @return string|null
     */
    public function getChannel()
    {
        return $this->channel;
    }
    /**
     * Set channel value
     * @param string $channel
     * @return \ApptitudeNamespace\StructType\XAgreement30
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($channel)), __LINE__);
        }
        $this->channel = $channel;
        return $this;
    }
    /**
     * Get activePriceGroup value
     * @return string|null
     */
    public function getActivePriceGroup()
    {
        return $this->activePriceGroup;
    }
    /**
     * Set activePriceGroup value
     * @param string $activePriceGroup
     * @return \ApptitudeNamespace\StructType\XAgreement30
     */
    public function setActivePriceGroup($activePriceGroup = null)
    {
        // validation for constraint: string
        if (!is_null($activePriceGroup) && !is_string($activePriceGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activePriceGroup)), __LINE__);
        }
        $this->activePriceGroup = $activePriceGroup;
        return $this;
    }
    /**
     * Get nextPriceGroup value
     * @return string|null
     */
    public function getNextPriceGroup()
    {
        return $this->nextPriceGroup;
    }
    /**
     * Set nextPriceGroup value
     * @param string $nextPriceGroup
     * @return \ApptitudeNamespace\StructType\XAgreement30
     */
    public function setNextPriceGroup($nextPriceGroup = null)
    {
        // validation for constraint: string
        if (!is_null($nextPriceGroup) && !is_string($nextPriceGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextPriceGroup)), __LINE__);
        }
        $this->nextPriceGroup = $nextPriceGroup;
        return $this;
    }
    /**
     * Get nextPriceGroupDate value
     * @return string|null
     */
    public function getNextPriceGroupDate()
    {
        return $this->nextPriceGroupDate;
    }
    /**
     * Set nextPriceGroupDate value
     * @param string $nextPriceGroupDate
     * @return \ApptitudeNamespace\StructType\XAgreement30
     */
    public function setNextPriceGroupDate($nextPriceGroupDate = null)
    {
        // validation for constraint: string
        if (!is_null($nextPriceGroupDate) && !is_string($nextPriceGroupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextPriceGroupDate)), __LINE__);
        }
        $this->nextPriceGroupDate = $nextPriceGroupDate;
        return $this;
    }
    /**
     * Get currencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }
    /**
     * Set currencyCode value
     * @param string $currencyCode
     * @return \ApptitudeNamespace\StructType\XAgreement30
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->currencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get marginGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XMarginGroup30[]|null
     */
    public function getMarginGroup()
    {
        return isset($this->marginGroup) ? $this->marginGroup : null;
    }
    /**
     * Set marginGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XMarginGroup30[] $marginGroup
     * @return \ApptitudeNamespace\StructType\XAgreement30
     */
    public function setMarginGroup(array $marginGroup = array())
    {
        foreach ($marginGroup as $xAgreement30MarginGroupItem) {
            // validation for constraint: itemType
            if (!$xAgreement30MarginGroupItem instanceof \ApptitudeNamespace\StructType\XMarginGroup30) {
                throw new \InvalidArgumentException(sprintf('The marginGroup property can only contain items of \ApptitudeNamespace\StructType\XMarginGroup30, "%s" given', is_object($xAgreement30MarginGroupItem) ? get_class($xAgreement30MarginGroupItem) : gettype($xAgreement30MarginGroupItem)), __LINE__);
            }
        }
        if (is_null($marginGroup) || (is_array($marginGroup) && empty($marginGroup))) {
            unset($this->marginGroup);
        } else {
            $this->marginGroup = $marginGroup;
        }
        return $this;
    }
    /**
     * Add item to marginGroup value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XMarginGroup30 $item
     * @return \ApptitudeNamespace\StructType\XAgreement30
     */
    public function addToMarginGroup(\ApptitudeNamespace\StructType\XMarginGroup30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XMarginGroup30) {
            throw new \InvalidArgumentException(sprintf('The marginGroup property can only contain items of \ApptitudeNamespace\StructType\XMarginGroup30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->marginGroup[] = $item;
        return $this;
    }
    /**
     * Get discountGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XDiscountGroup30[]|null
     */
    public function getDiscountGroup()
    {
        return isset($this->discountGroup) ? $this->discountGroup : null;
    }
    /**
     * Set discountGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XDiscountGroup30[] $discountGroup
     * @return \ApptitudeNamespace\StructType\XAgreement30
     */
    public function setDiscountGroup(array $discountGroup = array())
    {
        foreach ($discountGroup as $xAgreement30DiscountGroupItem) {
            // validation for constraint: itemType
            if (!$xAgreement30DiscountGroupItem instanceof \ApptitudeNamespace\StructType\XDiscountGroup30) {
                throw new \InvalidArgumentException(sprintf('The discountGroup property can only contain items of \ApptitudeNamespace\StructType\XDiscountGroup30, "%s" given', is_object($xAgreement30DiscountGroupItem) ? get_class($xAgreement30DiscountGroupItem) : gettype($xAgreement30DiscountGroupItem)), __LINE__);
            }
        }
        if (is_null($discountGroup) || (is_array($discountGroup) && empty($discountGroup))) {
            unset($this->discountGroup);
        } else {
            $this->discountGroup = $discountGroup;
        }
        return $this;
    }
    /**
     * Add item to discountGroup value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XDiscountGroup30 $item
     * @return \ApptitudeNamespace\StructType\XAgreement30
     */
    public function addToDiscountGroup(\ApptitudeNamespace\StructType\XDiscountGroup30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XDiscountGroup30) {
            throw new \InvalidArgumentException(sprintf('The discountGroup property can only contain items of \ApptitudeNamespace\StructType\XDiscountGroup30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->discountGroup[] = $item;
        return $this;
    }
    /**
     * Get orderFooter value
     * @return string|null
     */
    public function getOrderFooter()
    {
        return $this->orderFooter;
    }
    /**
     * Set orderFooter value
     * @param string $orderFooter
     * @return \ApptitudeNamespace\StructType\XAgreement30
     */
    public function setOrderFooter($orderFooter = null)
    {
        // validation for constraint: string
        if (!is_null($orderFooter) && !is_string($orderFooter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderFooter)), __LINE__);
        }
        $this->orderFooter = $orderFooter;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\XAgreement30
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
