<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xAgentCustomerAccess30 StructType
 * @subpackage Structs
 */
class XAgentCustomerAccess30 extends XObject30
{
    /**
     * The agentEmail
     * @var string
     */
    public $agentEmail;
    /**
     * The agentDefaultCurrency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $agentDefaultCurrency;
    /**
     * The agentDefaultPriceGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $agentDefaultPriceGroup;
    /**
     * The customerAccessRecords
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XCustomerAccessRecord30[]
     */
    public $customerAccessRecords;
    /**
     * Constructor method for xAgentCustomerAccess30
     * @uses XAgentCustomerAccess30::setAgentEmail()
     * @uses XAgentCustomerAccess30::setAgentDefaultCurrency()
     * @uses XAgentCustomerAccess30::setAgentDefaultPriceGroup()
     * @uses XAgentCustomerAccess30::setCustomerAccessRecords()
     * @param string $agentEmail
     * @param string $agentDefaultCurrency
     * @param string $agentDefaultPriceGroup
     * @param \ApptitudeNamespace\StructType\XCustomerAccessRecord30[] $customerAccessRecords
     */
    public function __construct($agentEmail = null, $agentDefaultCurrency = null, $agentDefaultPriceGroup = null, array $customerAccessRecords = array())
    {
        $this
            ->setAgentEmail($agentEmail)
            ->setAgentDefaultCurrency($agentDefaultCurrency)
            ->setAgentDefaultPriceGroup($agentDefaultPriceGroup)
            ->setCustomerAccessRecords($customerAccessRecords);
    }
    /**
     * Get agentEmail value
     * @return string|null
     */
    public function getAgentEmail()
    {
        return $this->agentEmail;
    }
    /**
     * Set agentEmail value
     * @param string $agentEmail
     * @return \ApptitudeNamespace\StructType\XAgentCustomerAccess30
     */
    public function setAgentEmail($agentEmail = null)
    {
        // validation for constraint: string
        if (!is_null($agentEmail) && !is_string($agentEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentEmail)), __LINE__);
        }
        $this->agentEmail = $agentEmail;
        return $this;
    }
    /**
     * Get agentDefaultCurrency value
     * @return string|null
     */
    public function getAgentDefaultCurrency()
    {
        return $this->agentDefaultCurrency;
    }
    /**
     * Set agentDefaultCurrency value
     * @param string $agentDefaultCurrency
     * @return \ApptitudeNamespace\StructType\XAgentCustomerAccess30
     */
    public function setAgentDefaultCurrency($agentDefaultCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($agentDefaultCurrency) && !is_string($agentDefaultCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentDefaultCurrency)), __LINE__);
        }
        $this->agentDefaultCurrency = $agentDefaultCurrency;
        return $this;
    }
    /**
     * Get agentDefaultPriceGroup value
     * @return string|null
     */
    public function getAgentDefaultPriceGroup()
    {
        return $this->agentDefaultPriceGroup;
    }
    /**
     * Set agentDefaultPriceGroup value
     * @param string $agentDefaultPriceGroup
     * @return \ApptitudeNamespace\StructType\XAgentCustomerAccess30
     */
    public function setAgentDefaultPriceGroup($agentDefaultPriceGroup = null)
    {
        // validation for constraint: string
        if (!is_null($agentDefaultPriceGroup) && !is_string($agentDefaultPriceGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentDefaultPriceGroup)), __LINE__);
        }
        $this->agentDefaultPriceGroup = $agentDefaultPriceGroup;
        return $this;
    }
    /**
     * Get customerAccessRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XCustomerAccessRecord30[]|null
     */
    public function getCustomerAccessRecords()
    {
        return isset($this->customerAccessRecords) ? $this->customerAccessRecords : null;
    }
    /**
     * Set customerAccessRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XCustomerAccessRecord30[] $customerAccessRecords
     * @return \ApptitudeNamespace\StructType\XAgentCustomerAccess30
     */
    public function setCustomerAccessRecords(array $customerAccessRecords = array())
    {
        foreach ($customerAccessRecords as $xAgentCustomerAccess30CustomerAccessRecordsItem) {
            // validation for constraint: itemType
            if (!$xAgentCustomerAccess30CustomerAccessRecordsItem instanceof \ApptitudeNamespace\StructType\XCustomerAccessRecord30) {
                throw new \InvalidArgumentException(sprintf('The customerAccessRecords property can only contain items of \ApptitudeNamespace\StructType\XCustomerAccessRecord30, "%s" given', is_object($xAgentCustomerAccess30CustomerAccessRecordsItem) ? get_class($xAgentCustomerAccess30CustomerAccessRecordsItem) : gettype($xAgentCustomerAccess30CustomerAccessRecordsItem)), __LINE__);
            }
        }
        if (is_null($customerAccessRecords) || (is_array($customerAccessRecords) && empty($customerAccessRecords))) {
            unset($this->customerAccessRecords);
        } else {
            $this->customerAccessRecords = $customerAccessRecords;
        }
        return $this;
    }
    /**
     * Add item to customerAccessRecords value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XCustomerAccessRecord30 $item
     * @return \ApptitudeNamespace\StructType\XAgentCustomerAccess30
     */
    public function addToCustomerAccessRecords(\ApptitudeNamespace\StructType\XCustomerAccessRecord30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XCustomerAccessRecord30) {
            throw new \InvalidArgumentException(sprintf('The customerAccessRecords property can only contain items of \ApptitudeNamespace\StructType\XCustomerAccessRecord30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->customerAccessRecords[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\XAgentCustomerAccess30
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
