<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateStock StructType
 * Meta informations extracted from the WSDL
 * - type: tns:updateStock
 * @subpackage Structs
 */
class UpdateStock extends AbstractStructBase
{
    /**
     * The apiKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $apiKey;
    /**
     * The stockInfoElement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XStockInfoElement30[]
     */
    public $stockInfoElement;
    /**
     * Constructor method for updateStock
     * @uses UpdateStock::setApiKey()
     * @uses UpdateStock::setStockInfoElement()
     * @param string $apiKey
     * @param \ApptitudeNamespace\StructType\XStockInfoElement30[] $stockInfoElement
     */
    public function __construct($apiKey = null, array $stockInfoElement = array())
    {
        $this
            ->setApiKey($apiKey)
            ->setStockInfoElement($stockInfoElement);
    }
    /**
     * Get apiKey value
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \ApptitudeNamespace\StructType\UpdateStock
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apiKey)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
    /**
     * Get stockInfoElement value
     * @return \ApptitudeNamespace\StructType\XStockInfoElement30[]|null
     */
    public function getStockInfoElement()
    {
        return $this->stockInfoElement;
    }
    /**
     * Set stockInfoElement value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XStockInfoElement30[] $stockInfoElement
     * @return \ApptitudeNamespace\StructType\UpdateStock
     */
    public function setStockInfoElement(array $stockInfoElement = array())
    {
        foreach ($stockInfoElement as $updateStockStockInfoElementItem) {
            // validation for constraint: itemType
            if (!$updateStockStockInfoElementItem instanceof \ApptitudeNamespace\StructType\XStockInfoElement30) {
                throw new \InvalidArgumentException(sprintf('The stockInfoElement property can only contain items of \ApptitudeNamespace\StructType\XStockInfoElement30, "%s" given', is_object($updateStockStockInfoElementItem) ? get_class($updateStockStockInfoElementItem) : gettype($updateStockStockInfoElementItem)), __LINE__);
            }
        }
        $this->stockInfoElement = $stockInfoElement;
        return $this;
    }
    /**
     * Add item to stockInfoElement value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XStockInfoElement30 $item
     * @return \ApptitudeNamespace\StructType\UpdateStock
     */
    public function addToStockInfoElement(\ApptitudeNamespace\StructType\XStockInfoElement30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XStockInfoElement30) {
            throw new \InvalidArgumentException(sprintf('The stockInfoElement property can only contain items of \ApptitudeNamespace\StructType\XStockInfoElement30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockInfoElement[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\UpdateStock
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
