<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updatePrices StructType
 * Meta informations extracted from the WSDL
 * - type: tns:updatePrices
 * @subpackage Structs
 */
class UpdatePrices extends AbstractStructBase
{
    /**
     * The apiKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $apiKey;
    /**
     * The priceInfoElement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XPriceInfoElement30[]
     */
    public $priceInfoElement;
    /**
     * Constructor method for updatePrices
     * @uses UpdatePrices::setApiKey()
     * @uses UpdatePrices::setPriceInfoElement()
     * @param string $apiKey
     * @param \ApptitudeNamespace\StructType\XPriceInfoElement30[] $priceInfoElement
     */
    public function __construct($apiKey = null, array $priceInfoElement = array())
    {
        $this
            ->setApiKey($apiKey)
            ->setPriceInfoElement($priceInfoElement);
    }
    /**
     * Get apiKey value
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \ApptitudeNamespace\StructType\UpdatePrices
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apiKey)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
    /**
     * Get priceInfoElement value
     * @return \ApptitudeNamespace\StructType\XPriceInfoElement30[]|null
     */
    public function getPriceInfoElement()
    {
        return $this->priceInfoElement;
    }
    /**
     * Set priceInfoElement value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XPriceInfoElement30[] $priceInfoElement
     * @return \ApptitudeNamespace\StructType\UpdatePrices
     */
    public function setPriceInfoElement(array $priceInfoElement = array())
    {
        foreach ($priceInfoElement as $updatePricesPriceInfoElementItem) {
            // validation for constraint: itemType
            if (!$updatePricesPriceInfoElementItem instanceof \ApptitudeNamespace\StructType\XPriceInfoElement30) {
                throw new \InvalidArgumentException(sprintf('The priceInfoElement property can only contain items of \ApptitudeNamespace\StructType\XPriceInfoElement30, "%s" given', is_object($updatePricesPriceInfoElementItem) ? get_class($updatePricesPriceInfoElementItem) : gettype($updatePricesPriceInfoElementItem)), __LINE__);
            }
        }
        $this->priceInfoElement = $priceInfoElement;
        return $this;
    }
    /**
     * Add item to priceInfoElement value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XPriceInfoElement30 $item
     * @return \ApptitudeNamespace\StructType\UpdatePrices
     */
    public function addToPriceInfoElement(\ApptitudeNamespace\StructType\XPriceInfoElement30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XPriceInfoElement30) {
            throw new \InvalidArgumentException(sprintf('The priceInfoElement property can only contain items of \ApptitudeNamespace\StructType\XPriceInfoElement30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->priceInfoElement[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\UpdatePrices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
