<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for storeFullHistoricalOrderSetForCustomer StructType
 * Meta informations extracted from the WSDL
 * - type: tns:storeFullHistoricalOrderSetForCustomer
 * @subpackage Structs
 */
class StoreFullHistoricalOrderSetForCustomer extends AbstractStructBase
{
    /**
     * The apiKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $apiKey;
    /**
     * The customerNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerNo;
    /**
     * The historicalOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XHistoricalOrder30[]
     */
    public $historicalOrder;
    /**
     * Constructor method for storeFullHistoricalOrderSetForCustomer
     * @uses StoreFullHistoricalOrderSetForCustomer::setApiKey()
     * @uses StoreFullHistoricalOrderSetForCustomer::setCustomerNo()
     * @uses StoreFullHistoricalOrderSetForCustomer::setHistoricalOrder()
     * @param string $apiKey
     * @param string $customerNo
     * @param \ApptitudeNamespace\StructType\XHistoricalOrder30[] $historicalOrder
     */
    public function __construct($apiKey = null, $customerNo = null, array $historicalOrder = array())
    {
        $this
            ->setApiKey($apiKey)
            ->setCustomerNo($customerNo)
            ->setHistoricalOrder($historicalOrder);
    }
    /**
     * Get apiKey value
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \ApptitudeNamespace\StructType\StoreFullHistoricalOrderSetForCustomer
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apiKey)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
    /**
     * Get customerNo value
     * @return string|null
     */
    public function getCustomerNo()
    {
        return $this->customerNo;
    }
    /**
     * Set customerNo value
     * @param string $customerNo
     * @return \ApptitudeNamespace\StructType\StoreFullHistoricalOrderSetForCustomer
     */
    public function setCustomerNo($customerNo = null)
    {
        // validation for constraint: string
        if (!is_null($customerNo) && !is_string($customerNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerNo)), __LINE__);
        }
        $this->customerNo = $customerNo;
        return $this;
    }
    /**
     * Get historicalOrder value
     * @return \ApptitudeNamespace\StructType\XHistoricalOrder30[]|null
     */
    public function getHistoricalOrder()
    {
        return $this->historicalOrder;
    }
    /**
     * Set historicalOrder value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XHistoricalOrder30[] $historicalOrder
     * @return \ApptitudeNamespace\StructType\StoreFullHistoricalOrderSetForCustomer
     */
    public function setHistoricalOrder(array $historicalOrder = array())
    {
        foreach ($historicalOrder as $storeFullHistoricalOrderSetForCustomerHistoricalOrderItem) {
            // validation for constraint: itemType
            if (!$storeFullHistoricalOrderSetForCustomerHistoricalOrderItem instanceof \ApptitudeNamespace\StructType\XHistoricalOrder30) {
                throw new \InvalidArgumentException(sprintf('The historicalOrder property can only contain items of \ApptitudeNamespace\StructType\XHistoricalOrder30, "%s" given', is_object($storeFullHistoricalOrderSetForCustomerHistoricalOrderItem) ? get_class($storeFullHistoricalOrderSetForCustomerHistoricalOrderItem) : gettype($storeFullHistoricalOrderSetForCustomerHistoricalOrderItem)), __LINE__);
            }
        }
        $this->historicalOrder = $historicalOrder;
        return $this;
    }
    /**
     * Add item to historicalOrder value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XHistoricalOrder30 $item
     * @return \ApptitudeNamespace\StructType\StoreFullHistoricalOrderSetForCustomer
     */
    public function addToHistoricalOrder(\ApptitudeNamespace\StructType\XHistoricalOrder30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XHistoricalOrder30) {
            throw new \InvalidArgumentException(sprintf('The historicalOrder property can only contain items of \ApptitudeNamespace\StructType\XHistoricalOrder30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->historicalOrder[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\StoreFullHistoricalOrderSetForCustomer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
