<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for storeFullCustomerAccessSetForAgent StructType
 * Meta informations extracted from the WSDL
 * - type: tns:storeFullCustomerAccessSetForAgent
 * @subpackage Structs
 */
class StoreFullCustomerAccessSetForAgent extends AbstractStructBase
{
    /**
     * The apiKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $apiKey;
    /**
     * The agentEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $agentEmail;
    /**
     * The agentDefaultPriceGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $agentDefaultPriceGroup;
    /**
     * The agentDefaultCurrency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $agentDefaultCurrency;
    /**
     * The customerAccessRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XCustomerAccessRecord30[]
     */
    public $customerAccessRecord;
    /**
     * Constructor method for storeFullCustomerAccessSetForAgent
     * @uses StoreFullCustomerAccessSetForAgent::setApiKey()
     * @uses StoreFullCustomerAccessSetForAgent::setAgentEmail()
     * @uses StoreFullCustomerAccessSetForAgent::setAgentDefaultPriceGroup()
     * @uses StoreFullCustomerAccessSetForAgent::setAgentDefaultCurrency()
     * @uses StoreFullCustomerAccessSetForAgent::setCustomerAccessRecord()
     * @param string $apiKey
     * @param string $agentEmail
     * @param string $agentDefaultPriceGroup
     * @param string $agentDefaultCurrency
     * @param \ApptitudeNamespace\StructType\XCustomerAccessRecord30[] $customerAccessRecord
     */
    public function __construct($apiKey = null, $agentEmail = null, $agentDefaultPriceGroup = null, $agentDefaultCurrency = null, array $customerAccessRecord = array())
    {
        $this
            ->setApiKey($apiKey)
            ->setAgentEmail($agentEmail)
            ->setAgentDefaultPriceGroup($agentDefaultPriceGroup)
            ->setAgentDefaultCurrency($agentDefaultCurrency)
            ->setCustomerAccessRecord($customerAccessRecord);
    }
    /**
     * Get apiKey value
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \ApptitudeNamespace\StructType\StoreFullCustomerAccessSetForAgent
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apiKey)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
    /**
     * Get agentEmail value
     * @return string|null
     */
    public function getAgentEmail()
    {
        return $this->agentEmail;
    }
    /**
     * Set agentEmail value
     * @param string $agentEmail
     * @return \ApptitudeNamespace\StructType\StoreFullCustomerAccessSetForAgent
     */
    public function setAgentEmail($agentEmail = null)
    {
        // validation for constraint: string
        if (!is_null($agentEmail) && !is_string($agentEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentEmail)), __LINE__);
        }
        $this->agentEmail = $agentEmail;
        return $this;
    }
    /**
     * Get agentDefaultPriceGroup value
     * @return string|null
     */
    public function getAgentDefaultPriceGroup()
    {
        return $this->agentDefaultPriceGroup;
    }
    /**
     * Set agentDefaultPriceGroup value
     * @param string $agentDefaultPriceGroup
     * @return \ApptitudeNamespace\StructType\StoreFullCustomerAccessSetForAgent
     */
    public function setAgentDefaultPriceGroup($agentDefaultPriceGroup = null)
    {
        // validation for constraint: string
        if (!is_null($agentDefaultPriceGroup) && !is_string($agentDefaultPriceGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentDefaultPriceGroup)), __LINE__);
        }
        $this->agentDefaultPriceGroup = $agentDefaultPriceGroup;
        return $this;
    }
    /**
     * Get agentDefaultCurrency value
     * @return string|null
     */
    public function getAgentDefaultCurrency()
    {
        return $this->agentDefaultCurrency;
    }
    /**
     * Set agentDefaultCurrency value
     * @param string $agentDefaultCurrency
     * @return \ApptitudeNamespace\StructType\StoreFullCustomerAccessSetForAgent
     */
    public function setAgentDefaultCurrency($agentDefaultCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($agentDefaultCurrency) && !is_string($agentDefaultCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentDefaultCurrency)), __LINE__);
        }
        $this->agentDefaultCurrency = $agentDefaultCurrency;
        return $this;
    }
    /**
     * Get customerAccessRecord value
     * @return \ApptitudeNamespace\StructType\XCustomerAccessRecord30[]|null
     */
    public function getCustomerAccessRecord()
    {
        return $this->customerAccessRecord;
    }
    /**
     * Set customerAccessRecord value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XCustomerAccessRecord30[] $customerAccessRecord
     * @return \ApptitudeNamespace\StructType\StoreFullCustomerAccessSetForAgent
     */
    public function setCustomerAccessRecord(array $customerAccessRecord = array())
    {
        foreach ($customerAccessRecord as $storeFullCustomerAccessSetForAgentCustomerAccessRecordItem) {
            // validation for constraint: itemType
            if (!$storeFullCustomerAccessSetForAgentCustomerAccessRecordItem instanceof \ApptitudeNamespace\StructType\XCustomerAccessRecord30) {
                throw new \InvalidArgumentException(sprintf('The customerAccessRecord property can only contain items of \ApptitudeNamespace\StructType\XCustomerAccessRecord30, "%s" given', is_object($storeFullCustomerAccessSetForAgentCustomerAccessRecordItem) ? get_class($storeFullCustomerAccessSetForAgentCustomerAccessRecordItem) : gettype($storeFullCustomerAccessSetForAgentCustomerAccessRecordItem)), __LINE__);
            }
        }
        $this->customerAccessRecord = $customerAccessRecord;
        return $this;
    }
    /**
     * Add item to customerAccessRecord value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XCustomerAccessRecord30 $item
     * @return \ApptitudeNamespace\StructType\StoreFullCustomerAccessSetForAgent
     */
    public function addToCustomerAccessRecord(\ApptitudeNamespace\StructType\XCustomerAccessRecord30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XCustomerAccessRecord30) {
            throw new \InvalidArgumentException(sprintf('The customerAccessRecord property can only contain items of \ApptitudeNamespace\StructType\XCustomerAccessRecord30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->customerAccessRecord[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\StoreFullCustomerAccessSetForAgent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
