<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for markOrdersAsProcessed StructType
 * Meta informations extracted from the WSDL
 * - type: tns:markOrdersAsProcessed
 * @subpackage Structs
 */
class MarkOrdersAsProcessed extends AbstractStructBase
{
    /**
     * The apiKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $apiKey;
    /**
     * The orderNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $orderNumber;
    /**
     * Constructor method for markOrdersAsProcessed
     * @uses MarkOrdersAsProcessed::setApiKey()
     * @uses MarkOrdersAsProcessed::setOrderNumber()
     * @param string $apiKey
     * @param string[] $orderNumber
     */
    public function __construct($apiKey = null, array $orderNumber = array())
    {
        $this
            ->setApiKey($apiKey)
            ->setOrderNumber($orderNumber);
    }
    /**
     * Get apiKey value
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \ApptitudeNamespace\StructType\MarkOrdersAsProcessed
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apiKey)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string[]|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @throws \InvalidArgumentException
     * @param string[] $orderNumber
     * @return \ApptitudeNamespace\StructType\MarkOrdersAsProcessed
     */
    public function setOrderNumber(array $orderNumber = array())
    {
        foreach ($orderNumber as $markOrdersAsProcessedOrderNumberItem) {
            // validation for constraint: itemType
            if (!is_string($markOrdersAsProcessedOrderNumberItem)) {
                throw new \InvalidArgumentException(sprintf('The orderNumber property can only contain items of string, "%s" given', is_object($markOrdersAsProcessedOrderNumberItem) ? get_class($markOrdersAsProcessedOrderNumberItem) : gettype($markOrdersAsProcessedOrderNumberItem)), __LINE__);
            }
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Add item to orderNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ApptitudeNamespace\StructType\MarkOrdersAsProcessed
     */
    public function addToOrderNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The orderNumber property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderNumber[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\MarkOrdersAsProcessed
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
