<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deleteHistoricalOrders StructType
 * Meta informations extracted from the WSDL
 * - type: tns:deleteHistoricalOrders
 * @subpackage Structs
 */
class DeleteHistoricalOrders extends AbstractStructBase
{
    /**
     * The apiKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $apiKey;
    /**
     * The historicalOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XHistoricalOrder30[]
     */
    public $historicalOrder;
    /**
     * Constructor method for deleteHistoricalOrders
     * @uses DeleteHistoricalOrders::setApiKey()
     * @uses DeleteHistoricalOrders::setHistoricalOrder()
     * @param string $apiKey
     * @param \ApptitudeNamespace\StructType\XHistoricalOrder30[] $historicalOrder
     */
    public function __construct($apiKey = null, array $historicalOrder = array())
    {
        $this
            ->setApiKey($apiKey)
            ->setHistoricalOrder($historicalOrder);
    }
    /**
     * Get apiKey value
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \ApptitudeNamespace\StructType\DeleteHistoricalOrders
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apiKey)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
    /**
     * Get historicalOrder value
     * @return \ApptitudeNamespace\StructType\XHistoricalOrder30[]|null
     */
    public function getHistoricalOrder()
    {
        return $this->historicalOrder;
    }
    /**
     * Set historicalOrder value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XHistoricalOrder30[] $historicalOrder
     * @return \ApptitudeNamespace\StructType\DeleteHistoricalOrders
     */
    public function setHistoricalOrder(array $historicalOrder = array())
    {
        foreach ($historicalOrder as $deleteHistoricalOrdersHistoricalOrderItem) {
            // validation for constraint: itemType
            if (!$deleteHistoricalOrdersHistoricalOrderItem instanceof \ApptitudeNamespace\StructType\XHistoricalOrder30) {
                throw new \InvalidArgumentException(sprintf('The historicalOrder property can only contain items of \ApptitudeNamespace\StructType\XHistoricalOrder30, "%s" given', is_object($deleteHistoricalOrdersHistoricalOrderItem) ? get_class($deleteHistoricalOrdersHistoricalOrderItem) : gettype($deleteHistoricalOrdersHistoricalOrderItem)), __LINE__);
            }
        }
        $this->historicalOrder = $historicalOrder;
        return $this;
    }
    /**
     * Add item to historicalOrder value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XHistoricalOrder30 $item
     * @return \ApptitudeNamespace\StructType\DeleteHistoricalOrders
     */
    public function addToHistoricalOrder(\ApptitudeNamespace\StructType\XHistoricalOrder30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XHistoricalOrder30) {
            throw new \InvalidArgumentException(sprintf('The historicalOrder property can only contain items of \ApptitudeNamespace\StructType\XHistoricalOrder30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->historicalOrder[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\DeleteHistoricalOrders
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
