<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deleteCustomers StructType
 * Meta informations extracted from the WSDL
 * - type: tns:deleteCustomers
 * @subpackage Structs
 */
class DeleteCustomers extends AbstractStructBase
{
    /**
     * The apiKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $apiKey;
    /**
     * The customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XCustomer30[]
     */
    public $customer;
    /**
     * Constructor method for deleteCustomers
     * @uses DeleteCustomers::setApiKey()
     * @uses DeleteCustomers::setCustomer()
     * @param string $apiKey
     * @param \ApptitudeNamespace\StructType\XCustomer30[] $customer
     */
    public function __construct($apiKey = null, array $customer = array())
    {
        $this
            ->setApiKey($apiKey)
            ->setCustomer($customer);
    }
    /**
     * Get apiKey value
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \ApptitudeNamespace\StructType\DeleteCustomers
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apiKey)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
    /**
     * Get customer value
     * @return \ApptitudeNamespace\StructType\XCustomer30[]|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XCustomer30[] $customer
     * @return \ApptitudeNamespace\StructType\DeleteCustomers
     */
    public function setCustomer(array $customer = array())
    {
        foreach ($customer as $deleteCustomersCustomerItem) {
            // validation for constraint: itemType
            if (!$deleteCustomersCustomerItem instanceof \ApptitudeNamespace\StructType\XCustomer30) {
                throw new \InvalidArgumentException(sprintf('The customer property can only contain items of \ApptitudeNamespace\StructType\XCustomer30, "%s" given', is_object($deleteCustomersCustomerItem) ? get_class($deleteCustomersCustomerItem) : gettype($deleteCustomersCustomerItem)), __LINE__);
            }
        }
        $this->customer = $customer;
        return $this;
    }
    /**
     * Add item to customer value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XCustomer30 $item
     * @return \ApptitudeNamespace\StructType\DeleteCustomers
     */
    public function addToCustomer(\ApptitudeNamespace\StructType\XCustomer30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XCustomer30) {
            throw new \InvalidArgumentException(sprintf('The customer property can only contain items of \ApptitudeNamespace\StructType\XCustomer30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->customer[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\DeleteCustomers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
