<?php

namespace ApptitudeNamespace\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\UpdateStock $parameters
     * @return \ApptitudeNamespace\StructType\UpdateStockResponse|bool
     */
    public function updateStock(\ApptitudeNamespace\StructType\UpdateStock $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->updateStock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePrices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\UpdatePrices $parameters
     * @return \ApptitudeNamespace\StructType\UpdatePricesResponse|bool
     */
    public function updatePrices(\ApptitudeNamespace\StructType\UpdatePrices $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->updatePrices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ApptitudeNamespace\StructType\UpdatePricesResponse|\ApptitudeNamespace\StructType\UpdateStockResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
