<?php

namespace ApptitudeNamespace\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Store ServiceType
 * @subpackage Services
 */
class Store extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named storeFullProductSet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\StoreFullProductSet $parameters
     * @return \ApptitudeNamespace\StructType\StoreFullProductSetResponse|bool
     */
    public function storeFullProductSet(\ApptitudeNamespace\StructType\StoreFullProductSet $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->storeFullProductSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named storeProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\StoreProducts $parameters
     * @return \ApptitudeNamespace\StructType\StoreProductsResponse|bool
     */
    public function storeProducts(\ApptitudeNamespace\StructType\StoreProducts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->storeProducts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named storeFullCustomerSet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\StoreFullCustomerSet $parameters
     * @return \ApptitudeNamespace\StructType\StoreFullCustomerSetResponse|bool
     */
    public function storeFullCustomerSet(\ApptitudeNamespace\StructType\StoreFullCustomerSet $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->storeFullCustomerSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named storeCustomers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\StoreCustomers $parameters
     * @return \ApptitudeNamespace\StructType\StoreCustomersResponse|bool
     */
    public function storeCustomers(\ApptitudeNamespace\StructType\StoreCustomers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->storeCustomers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named storeFullCustomerAccessSetForAgent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\StoreFullCustomerAccessSetForAgent $parameters
     * @return \ApptitudeNamespace\StructType\StoreFullCustomerAccessSetForAgentResponse|bool
     */
    public function storeFullCustomerAccessSetForAgent(\ApptitudeNamespace\StructType\StoreFullCustomerAccessSetForAgent $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->storeFullCustomerAccessSetForAgent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named storeFullCustomerAccessSet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\StoreFullCustomerAccessSet $parameters
     * @return \ApptitudeNamespace\StructType\StoreFullCustomerAccessSetResponse|bool
     */
    public function storeFullCustomerAccessSet(\ApptitudeNamespace\StructType\StoreFullCustomerAccessSet $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->storeFullCustomerAccessSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named storeFullProductAccessSet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\StoreFullProductAccessSet $parameters
     * @return \ApptitudeNamespace\StructType\StoreFullProductAccessSetResponse|bool
     */
    public function storeFullProductAccessSet(\ApptitudeNamespace\StructType\StoreFullProductAccessSet $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->storeFullProductAccessSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named storeProductAccessRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\StoreProductAccessRules $parameters
     * @return \ApptitudeNamespace\StructType\StoreProductAccessRulesResponse|bool
     */
    public function storeProductAccessRules(\ApptitudeNamespace\StructType\StoreProductAccessRules $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->storeProductAccessRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * storeFullHistoricalOrderSetForCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\StoreFullHistoricalOrderSetForCustomer $parameters
     * @return \ApptitudeNamespace\StructType\StoreFullHistoricalOrderSetForCustomerResponse|bool
     */
    public function storeFullHistoricalOrderSetForCustomer(\ApptitudeNamespace\StructType\StoreFullHistoricalOrderSetForCustomer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->storeFullHistoricalOrderSetForCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named storeHistoricalOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\StoreHistoricalOrders $parameters
     * @return \ApptitudeNamespace\StructType\StoreHistoricalOrdersResponse|bool
     */
    public function storeHistoricalOrders(\ApptitudeNamespace\StructType\StoreHistoricalOrders $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->storeHistoricalOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named storeFullInvoiceSetForCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\StoreFullInvoiceSetForCustomer $parameters
     * @return \ApptitudeNamespace\StructType\StoreFullInvoiceSetForCustomerResponse|bool
     */
    public function storeFullInvoiceSetForCustomer(\ApptitudeNamespace\StructType\StoreFullInvoiceSetForCustomer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->storeFullInvoiceSetForCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named storeInvoices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\StoreInvoices $parameters
     * @return \ApptitudeNamespace\StructType\StoreInvoicesResponse|bool
     */
    public function storeInvoices(\ApptitudeNamespace\StructType\StoreInvoices $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->storeInvoices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ApptitudeNamespace\StructType\StoreCustomersResponse|\ApptitudeNamespace\StructType\StoreFullCustomerAccessSetForAgentResponse|\ApptitudeNamespace\StructType\StoreFullCustomerAccessSetResponse|\ApptitudeNamespace\StructType\StoreFullCustomerSetResponse|\ApptitudeNamespace\StructType\StoreFullHistoricalOrderSetForCustomerResponse|\ApptitudeNamespace\StructType\StoreFullInvoiceSetForCustomerResponse|\ApptitudeNamespace\StructType\StoreFullProductAccessSetResponse|\ApptitudeNamespace\StructType\StoreFullProductSetResponse|\ApptitudeNamespace\StructType\StoreHistoricalOrdersResponse|\ApptitudeNamespace\StructType\StoreInvoicesResponse|\ApptitudeNamespace\StructType\StoreProductAccessRulesResponse|\ApptitudeNamespace\StructType\StoreProductsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
