<?php

namespace ApptitudeNamespace\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mark ServiceType
 * @subpackage Services
 */
class Mark extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named markOrdersAsProcessed
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\MarkOrdersAsProcessed $parameters
     * @return \ApptitudeNamespace\StructType\MarkOrdersAsProcessedResponse|bool
     */
    public function markOrdersAsProcessed(\ApptitudeNamespace\StructType\MarkOrdersAsProcessed $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->markOrdersAsProcessed($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ApptitudeNamespace\StructType\MarkOrdersAsProcessedResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
