<?php

namespace ApptitudeNamespace\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\DeleteProducts $parameters
     * @return \ApptitudeNamespace\StructType\DeleteProductsResponse|bool
     */
    public function deleteProducts(\ApptitudeNamespace\StructType\DeleteProducts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteProducts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteAllProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\DeleteAllProducts $parameters
     * @return \ApptitudeNamespace\StructType\DeleteAllProductsResponse|bool
     */
    public function deleteAllProducts(\ApptitudeNamespace\StructType\DeleteAllProducts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteAllProducts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteCustomers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\DeleteCustomers $parameters
     * @return \ApptitudeNamespace\StructType\DeleteCustomersResponse|bool
     */
    public function deleteCustomers(\ApptitudeNamespace\StructType\DeleteCustomers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteCustomers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteAllCustomers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\DeleteAllCustomers $parameters
     * @return \ApptitudeNamespace\StructType\DeleteAllCustomersResponse|bool
     */
    public function deleteAllCustomers(\ApptitudeNamespace\StructType\DeleteAllCustomers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteAllCustomers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * deleteProductAccessRulesForCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\DeleteProductAccessRulesForCustomer $parameters
     * @return \ApptitudeNamespace\StructType\DeleteProductAccessRulesForCustomerResponse|bool
     */
    public function deleteProductAccessRulesForCustomer(\ApptitudeNamespace\StructType\DeleteProductAccessRulesForCustomer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteProductAccessRulesForCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteProductAccessRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\DeleteProductAccessRules $parameters
     * @return \ApptitudeNamespace\StructType\DeleteProductAccessRulesResponse|bool
     */
    public function deleteProductAccessRules(\ApptitudeNamespace\StructType\DeleteProductAccessRules $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteProductAccessRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteAllProductAccessRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\DeleteAllProductAccessRules $parameters
     * @return \ApptitudeNamespace\StructType\DeleteAllProductAccessRulesResponse|bool
     */
    public function deleteAllProductAccessRules(\ApptitudeNamespace\StructType\DeleteAllProductAccessRules $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteAllProductAccessRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteHistoricalOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\DeleteHistoricalOrders $parameters
     * @return \ApptitudeNamespace\StructType\DeleteHistoricalOrdersResponse|bool
     */
    public function deleteHistoricalOrders(\ApptitudeNamespace\StructType\DeleteHistoricalOrders $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteHistoricalOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteAllHistoricalOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\DeleteAllHistoricalOrders $parameters
     * @return \ApptitudeNamespace\StructType\DeleteAllHistoricalOrdersResponse|bool
     */
    public function deleteAllHistoricalOrders(\ApptitudeNamespace\StructType\DeleteAllHistoricalOrders $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteAllHistoricalOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteInvoices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\DeleteInvoices $parameters
     * @return \ApptitudeNamespace\StructType\DeleteInvoicesResponse|bool
     */
    public function deleteInvoices(\ApptitudeNamespace\StructType\DeleteInvoices $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteInvoices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteAllInvoices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\DeleteAllInvoices $parameters
     * @return \ApptitudeNamespace\StructType\DeleteAllInvoicesResponse|bool
     */
    public function deleteAllInvoices(\ApptitudeNamespace\StructType\DeleteAllInvoices $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteAllInvoices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ApptitudeNamespace\StructType\DeleteAllCustomersResponse|\ApptitudeNamespace\StructType\DeleteAllHistoricalOrdersResponse|\ApptitudeNamespace\StructType\DeleteAllInvoicesResponse|\ApptitudeNamespace\StructType\DeleteAllProductAccessRulesResponse|\ApptitudeNamespace\StructType\DeleteAllProductsResponse|\ApptitudeNamespace\StructType\DeleteCustomersResponse|\ApptitudeNamespace\StructType\DeleteHistoricalOrdersResponse|\ApptitudeNamespace\StructType\DeleteInvoicesResponse|\ApptitudeNamespace\StructType\DeleteProductAccessRulesForCustomerResponse|\ApptitudeNamespace\StructType\DeleteProductAccessRulesResponse|\ApptitudeNamespace\StructType\DeleteProductsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
