<?php

namespace ApptitudeNamespace\EnumType;

/**
 * This class stands for xProductStatus30 EnumType
 * @subpackage Enumerations
 */
class XProductStatus30
{
    /**
     * Constant for value 'ACTIVE'
     * @return string 'ACTIVE'
     */
    const VALUE_ACTIVE = 'ACTIVE';
    /**
     * Constant for value 'CANCELED'
     * @return string 'CANCELED'
     */
    const VALUE_CANCELED = 'CANCELED';
    /**
     * Constant for value 'SOLDOUT'
     * @return string 'SOLDOUT'
     */
    const VALUE_SOLDOUT = 'SOLDOUT';
    /**
     * Constant for value 'INVISIBLE'
     * @return string 'INVISIBLE'
     */
    const VALUE_INVISIBLE = 'INVISIBLE';
    /**
     * Constant for value 'BLOCKED'
     * @return string 'BLOCKED'
     */
    const VALUE_BLOCKED = 'BLOCKED';
    /**
     * Constant for value 'BLOCKED_1'
     * @return string 'BLOCKED_1'
     */
    const VALUE_BLOCKED_1 = 'BLOCKED_1';
    /**
     * Constant for value 'BLOCKED_2'
     * @return string 'BLOCKED_2'
     */
    const VALUE_BLOCKED_2 = 'BLOCKED_2';
    /**
     * Constant for value 'BLOCKED_3'
     * @return string 'BLOCKED_3'
     */
    const VALUE_BLOCKED_3 = 'BLOCKED_3';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_CANCELED
     * @uses self::VALUE_SOLDOUT
     * @uses self::VALUE_INVISIBLE
     * @uses self::VALUE_BLOCKED
     * @uses self::VALUE_BLOCKED_1
     * @uses self::VALUE_BLOCKED_2
     * @uses self::VALUE_BLOCKED_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVE,
            self::VALUE_CANCELED,
            self::VALUE_SOLDOUT,
            self::VALUE_INVISIBLE,
            self::VALUE_BLOCKED,
            self::VALUE_BLOCKED_1,
            self::VALUE_BLOCKED_2,
            self::VALUE_BLOCKED_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
