<?php

namespace ApptitudeNamespace\EnumType;

/**
 * This class stands for xPriceType30 EnumType
 * @subpackage Enumerations
 */
class XPriceType30
{
    /**
     * Constant for value 'RETAIL'
     * @return string 'RETAIL'
     */
    const VALUE_RETAIL = 'RETAIL';
    /**
     * Constant for value 'WHOLESALE'
     * @return string 'WHOLESALE'
     */
    const VALUE_WHOLESALE = 'WHOLESALE';
    /**
     * Constant for value 'ORIGINAL_WHOLESALE'
     * @return string 'ORIGINAL_WHOLESALE'
     */
    const VALUE_ORIGINAL_WHOLESALE = 'ORIGINAL_WHOLESALE';
    /**
     * Constant for value 'PURCHASE'
     * @return string 'PURCHASE'
     */
    const VALUE_PURCHASE = 'PURCHASE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RETAIL
     * @uses self::VALUE_WHOLESALE
     * @uses self::VALUE_ORIGINAL_WHOLESALE
     * @uses self::VALUE_PURCHASE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RETAIL,
            self::VALUE_WHOLESALE,
            self::VALUE_ORIGINAL_WHOLESALE,
            self::VALUE_PURCHASE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
