<?php

namespace ApptitudeNamespace\EnumType;

/**
 * This class stands for xOrderStatus30 EnumType
 * @subpackage Enumerations
 */
class XOrderStatus30
{
    /**
     * Constant for value 'PROCESSING'
     * @return string 'PROCESSING'
     */
    const VALUE_PROCESSING = 'PROCESSING';
    /**
     * Constant for value 'PROCESSING_MOVED'
     * @return string 'PROCESSING_MOVED'
     */
    const VALUE_PROCESSING_MOVED = 'PROCESSING_MOVED';
    /**
     * Constant for value 'COOLING'
     * @return string 'COOLING'
     */
    const VALUE_COOLING = 'COOLING';
    /**
     * Constant for value 'COOLING_MOVED'
     * @return string 'COOLING_MOVED'
     */
    const VALUE_COOLING_MOVED = 'COOLING_MOVED';
    /**
     * Constant for value 'AT_CACHE'
     * @return string 'AT_CACHE'
     */
    const VALUE_AT_CACHE = 'AT_CACHE';
    /**
     * Constant for value 'AT_CACHE_MOVED'
     * @return string 'AT_CACHE_MOVED'
     */
    const VALUE_AT_CACHE_MOVED = 'AT_CACHE_MOVED';
    /**
     * Constant for value 'AT_CONNECTOR'
     * @return string 'AT_CONNECTOR'
     */
    const VALUE_AT_CONNECTOR = 'AT_CONNECTOR';
    /**
     * Constant for value 'AT_CONNECTOR_MOVED'
     * @return string 'AT_CONNECTOR_MOVED'
     */
    const VALUE_AT_CONNECTOR_MOVED = 'AT_CONNECTOR_MOVED';
    /**
     * Constant for value 'AT_DESTINATION'
     * @return string 'AT_DESTINATION'
     */
    const VALUE_AT_DESTINATION = 'AT_DESTINATION';
    /**
     * Constant for value 'AT_DESTINATION_MOVED'
     * @return string 'AT_DESTINATION_MOVED'
     */
    const VALUE_AT_DESTINATION_MOVED = 'AT_DESTINATION_MOVED';
    /**
     * Constant for value 'NO_DESTINATION'
     * @return string 'NO_DESTINATION'
     */
    const VALUE_NO_DESTINATION = 'NO_DESTINATION';
    /**
     * Constant for value 'NO_DESTINATION_MOVED'
     * @return string 'NO_DESTINATION_MOVED'
     */
    const VALUE_NO_DESTINATION_MOVED = 'NO_DESTINATION_MOVED';
    /**
     * Constant for value 'DUPLICATE'
     * @return string 'DUPLICATE'
     */
    const VALUE_DUPLICATE = 'DUPLICATE';
    /**
     * Constant for value 'DUPLICATE_MOVED'
     * @return string 'DUPLICATE_MOVED'
     */
    const VALUE_DUPLICATE_MOVED = 'DUPLICATE_MOVED';
    /**
     * Constant for value 'DRAFT'
     * @return string 'DRAFT'
     */
    const VALUE_DRAFT = 'DRAFT';
    /**
     * Constant for value 'DRAFT_MOVED'
     * @return string 'DRAFT_MOVED'
     */
    const VALUE_DRAFT_MOVED = 'DRAFT_MOVED';
    /**
     * Constant for value 'TO_BE_EDITED'
     * @return string 'TO_BE_EDITED'
     */
    const VALUE_TO_BE_EDITED = 'TO_BE_EDITED';
    /**
     * Constant for value 'TO_BE_EDITED_MOVED'
     * @return string 'TO_BE_EDITED_MOVED'
     */
    const VALUE_TO_BE_EDITED_MOVED = 'TO_BE_EDITED_MOVED';
    /**
     * Constant for value 'TO_BE_APPROVED'
     * @return string 'TO_BE_APPROVED'
     */
    const VALUE_TO_BE_APPROVED = 'TO_BE_APPROVED';
    /**
     * Constant for value 'TO_BE_APPROVED_MOVED'
     * @return string 'TO_BE_APPROVED_MOVED'
     */
    const VALUE_TO_BE_APPROVED_MOVED = 'TO_BE_APPROVED_MOVED';
    /**
     * Constant for value 'APPROVAL_DECLINED'
     * @return string 'APPROVAL_DECLINED'
     */
    const VALUE_APPROVAL_DECLINED = 'APPROVAL_DECLINED';
    /**
     * Constant for value 'APPROVAL_DECLINED_MOVED'
     * @return string 'APPROVAL_DECLINED_MOVED'
     */
    const VALUE_APPROVAL_DECLINED_MOVED = 'APPROVAL_DECLINED_MOVED';
    /**
     * Constant for value 'WAITING_FOR_PAYMENT'
     * @return string 'WAITING_FOR_PAYMENT'
     */
    const VALUE_WAITING_FOR_PAYMENT = 'WAITING_FOR_PAYMENT';
    /**
     * Constant for value 'WAITING_FOR_PAYMENT_MOVED'
     * @return string 'WAITING_FOR_PAYMENT_MOVED'
     */
    const VALUE_WAITING_FOR_PAYMENT_MOVED = 'WAITING_FOR_PAYMENT_MOVED';
    /**
     * Constant for value 'PAYMENT_FAILED'
     * @return string 'PAYMENT_FAILED'
     */
    const VALUE_PAYMENT_FAILED = 'PAYMENT_FAILED';
    /**
     * Constant for value 'PAYMENT_FAILED_MOVED'
     * @return string 'PAYMENT_FAILED_MOVED'
     */
    const VALUE_PAYMENT_FAILED_MOVED = 'PAYMENT_FAILED_MOVED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PROCESSING
     * @uses self::VALUE_PROCESSING_MOVED
     * @uses self::VALUE_COOLING
     * @uses self::VALUE_COOLING_MOVED
     * @uses self::VALUE_AT_CACHE
     * @uses self::VALUE_AT_CACHE_MOVED
     * @uses self::VALUE_AT_CONNECTOR
     * @uses self::VALUE_AT_CONNECTOR_MOVED
     * @uses self::VALUE_AT_DESTINATION
     * @uses self::VALUE_AT_DESTINATION_MOVED
     * @uses self::VALUE_NO_DESTINATION
     * @uses self::VALUE_NO_DESTINATION_MOVED
     * @uses self::VALUE_DUPLICATE
     * @uses self::VALUE_DUPLICATE_MOVED
     * @uses self::VALUE_DRAFT
     * @uses self::VALUE_DRAFT_MOVED
     * @uses self::VALUE_TO_BE_EDITED
     * @uses self::VALUE_TO_BE_EDITED_MOVED
     * @uses self::VALUE_TO_BE_APPROVED
     * @uses self::VALUE_TO_BE_APPROVED_MOVED
     * @uses self::VALUE_APPROVAL_DECLINED
     * @uses self::VALUE_APPROVAL_DECLINED_MOVED
     * @uses self::VALUE_WAITING_FOR_PAYMENT
     * @uses self::VALUE_WAITING_FOR_PAYMENT_MOVED
     * @uses self::VALUE_PAYMENT_FAILED
     * @uses self::VALUE_PAYMENT_FAILED_MOVED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PROCESSING,
            self::VALUE_PROCESSING_MOVED,
            self::VALUE_COOLING,
            self::VALUE_COOLING_MOVED,
            self::VALUE_AT_CACHE,
            self::VALUE_AT_CACHE_MOVED,
            self::VALUE_AT_CONNECTOR,
            self::VALUE_AT_CONNECTOR_MOVED,
            self::VALUE_AT_DESTINATION,
            self::VALUE_AT_DESTINATION_MOVED,
            self::VALUE_NO_DESTINATION,
            self::VALUE_NO_DESTINATION_MOVED,
            self::VALUE_DUPLICATE,
            self::VALUE_DUPLICATE_MOVED,
            self::VALUE_DRAFT,
            self::VALUE_DRAFT_MOVED,
            self::VALUE_TO_BE_EDITED,
            self::VALUE_TO_BE_EDITED_MOVED,
            self::VALUE_TO_BE_APPROVED,
            self::VALUE_TO_BE_APPROVED_MOVED,
            self::VALUE_APPROVAL_DECLINED,
            self::VALUE_APPROVAL_DECLINED_MOVED,
            self::VALUE_WAITING_FOR_PAYMENT,
            self::VALUE_WAITING_FOR_PAYMENT_MOVED,
            self::VALUE_PAYMENT_FAILED,
            self::VALUE_PAYMENT_FAILED_MOVED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
