<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xStockInfoElement30 StructType
 * @subpackage Structs
 */
class XStockInfoElement30 extends XObject30
{
    /**
     * The productUniqueId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productUniqueId;
    /**
     * The productColorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productColorCode;
    /**
     * The eanCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $eanCode;
    /**
     * The sizeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sizeName;
    /**
     * The subSizeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subSizeName;
    /**
     * The stockLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XStockLevel30[]
     */
    public $stockLevel;
    /**
     * Constructor method for xStockInfoElement30
     * @uses XStockInfoElement30::setProductUniqueId()
     * @uses XStockInfoElement30::setProductColorCode()
     * @uses XStockInfoElement30::setEanCode()
     * @uses XStockInfoElement30::setSizeName()
     * @uses XStockInfoElement30::setSubSizeName()
     * @uses XStockInfoElement30::setStockLevel()
     * @param string $productUniqueId
     * @param string $productColorCode
     * @param string $eanCode
     * @param string $sizeName
     * @param string $subSizeName
     * @param \ApptitudeNamespace\StructType\XStockLevel30[] $stockLevel
     */
    public function __construct($productUniqueId = null, $productColorCode = null, $eanCode = null, $sizeName = null, $subSizeName = null, array $stockLevel = array())
    {
        $this
            ->setProductUniqueId($productUniqueId)
            ->setProductColorCode($productColorCode)
            ->setEanCode($eanCode)
            ->setSizeName($sizeName)
            ->setSubSizeName($subSizeName)
            ->setStockLevel($stockLevel);
    }
    /**
     * Get productUniqueId value
     * @return string|null
     */
    public function getProductUniqueId()
    {
        return $this->productUniqueId;
    }
    /**
     * Set productUniqueId value
     * @param string $productUniqueId
     * @return \ApptitudeNamespace\StructType\XStockInfoElement30
     */
    public function setProductUniqueId($productUniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($productUniqueId) && !is_string($productUniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productUniqueId)), __LINE__);
        }
        $this->productUniqueId = $productUniqueId;
        return $this;
    }
    /**
     * Get productColorCode value
     * @return string|null
     */
    public function getProductColorCode()
    {
        return $this->productColorCode;
    }
    /**
     * Set productColorCode value
     * @param string $productColorCode
     * @return \ApptitudeNamespace\StructType\XStockInfoElement30
     */
    public function setProductColorCode($productColorCode = null)
    {
        // validation for constraint: string
        if (!is_null($productColorCode) && !is_string($productColorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productColorCode)), __LINE__);
        }
        $this->productColorCode = $productColorCode;
        return $this;
    }
    /**
     * Get eanCode value
     * @return string|null
     */
    public function getEanCode()
    {
        return $this->eanCode;
    }
    /**
     * Set eanCode value
     * @param string $eanCode
     * @return \ApptitudeNamespace\StructType\XStockInfoElement30
     */
    public function setEanCode($eanCode = null)
    {
        // validation for constraint: string
        if (!is_null($eanCode) && !is_string($eanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eanCode)), __LINE__);
        }
        $this->eanCode = $eanCode;
        return $this;
    }
    /**
     * Get sizeName value
     * @return string|null
     */
    public function getSizeName()
    {
        return $this->sizeName;
    }
    /**
     * Set sizeName value
     * @param string $sizeName
     * @return \ApptitudeNamespace\StructType\XStockInfoElement30
     */
    public function setSizeName($sizeName = null)
    {
        // validation for constraint: string
        if (!is_null($sizeName) && !is_string($sizeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sizeName)), __LINE__);
        }
        $this->sizeName = $sizeName;
        return $this;
    }
    /**
     * Get subSizeName value
     * @return string|null
     */
    public function getSubSizeName()
    {
        return $this->subSizeName;
    }
    /**
     * Set subSizeName value
     * @param string $subSizeName
     * @return \ApptitudeNamespace\StructType\XStockInfoElement30
     */
    public function setSubSizeName($subSizeName = null)
    {
        // validation for constraint: string
        if (!is_null($subSizeName) && !is_string($subSizeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subSizeName)), __LINE__);
        }
        $this->subSizeName = $subSizeName;
        return $this;
    }
    /**
     * Get stockLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XStockLevel30[]|null
     */
    public function getStockLevel()
    {
        return isset($this->stockLevel) ? $this->stockLevel : null;
    }
    /**
     * Set stockLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XStockLevel30[] $stockLevel
     * @return \ApptitudeNamespace\StructType\XStockInfoElement30
     */
    public function setStockLevel(array $stockLevel = array())
    {
        foreach ($stockLevel as $xStockInfoElement30StockLevelItem) {
            // validation for constraint: itemType
            if (!$xStockInfoElement30StockLevelItem instanceof \ApptitudeNamespace\StructType\XStockLevel30) {
                throw new \InvalidArgumentException(sprintf('The stockLevel property can only contain items of \ApptitudeNamespace\StructType\XStockLevel30, "%s" given', is_object($xStockInfoElement30StockLevelItem) ? get_class($xStockInfoElement30StockLevelItem) : gettype($xStockInfoElement30StockLevelItem)), __LINE__);
            }
        }
        if (is_null($stockLevel) || (is_array($stockLevel) && empty($stockLevel))) {
            unset($this->stockLevel);
        } else {
            $this->stockLevel = $stockLevel;
        }
        return $this;
    }
    /**
     * Add item to stockLevel value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XStockLevel30 $item
     * @return \ApptitudeNamespace\StructType\XStockInfoElement30
     */
    public function addToStockLevel(\ApptitudeNamespace\StructType\XStockLevel30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XStockLevel30) {
            throw new \InvalidArgumentException(sprintf('The stockLevel property can only contain items of \ApptitudeNamespace\StructType\XStockLevel30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockLevel[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\XStockInfoElement30
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
