<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xInvoice30 StructType
 * @subpackage Structs
 */
class XInvoice30 extends XObject30
{
    /**
     * The customerNo
     * @var string
     */
    public $customerNo;
    /**
     * The invoiceNumber
     * @var string
     */
    public $invoiceNumber;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The date
     * @var string
     */
    public $date;
    /**
     * The dueDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dueDate;
    /**
     * The currency
     * @var string
     */
    public $currency;
    /**
     * The amountExcludingTax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amountExcludingTax;
    /**
     * The taxAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxAmount;
    /**
     * The outstandingAmount
     * @var float
     */
    public $outstandingAmount;
    /**
     * The externalUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $externalUrl;
    /**
     * Constructor method for xInvoice30
     * @uses XInvoice30::setCustomerNo()
     * @uses XInvoice30::setInvoiceNumber()
     * @uses XInvoice30::setStatus()
     * @uses XInvoice30::setDate()
     * @uses XInvoice30::setDueDate()
     * @uses XInvoice30::setCurrency()
     * @uses XInvoice30::setAmountExcludingTax()
     * @uses XInvoice30::setTaxAmount()
     * @uses XInvoice30::setOutstandingAmount()
     * @uses XInvoice30::setExternalUrl()
     * @param string $customerNo
     * @param string $invoiceNumber
     * @param string $status
     * @param string $date
     * @param string $dueDate
     * @param string $currency
     * @param float $amountExcludingTax
     * @param float $taxAmount
     * @param float $outstandingAmount
     * @param string $externalUrl
     */
    public function __construct($customerNo = null, $invoiceNumber = null, $status = null, $date = null, $dueDate = null, $currency = null, $amountExcludingTax = null, $taxAmount = null, $outstandingAmount = null, $externalUrl = null)
    {
        $this
            ->setCustomerNo($customerNo)
            ->setInvoiceNumber($invoiceNumber)
            ->setStatus($status)
            ->setDate($date)
            ->setDueDate($dueDate)
            ->setCurrency($currency)
            ->setAmountExcludingTax($amountExcludingTax)
            ->setTaxAmount($taxAmount)
            ->setOutstandingAmount($outstandingAmount)
            ->setExternalUrl($externalUrl);
    }
    /**
     * Get customerNo value
     * @return string|null
     */
    public function getCustomerNo()
    {
        return $this->customerNo;
    }
    /**
     * Set customerNo value
     * @param string $customerNo
     * @return \ApptitudeNamespace\StructType\XInvoice30
     */
    public function setCustomerNo($customerNo = null)
    {
        // validation for constraint: string
        if (!is_null($customerNo) && !is_string($customerNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerNo)), __LINE__);
        }
        $this->customerNo = $customerNo;
        return $this;
    }
    /**
     * Get invoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->invoiceNumber;
    }
    /**
     * Set invoiceNumber value
     * @param string $invoiceNumber
     * @return \ApptitudeNamespace\StructType\XInvoice30
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceNumber)), __LINE__);
        }
        $this->invoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \ApptitudeNamespace\StructType\XInvoice30
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \ApptitudeNamespace\StructType\XInvoice30
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get dueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }
    /**
     * Set dueDate value
     * @param string $dueDate
     * @return \ApptitudeNamespace\StructType\XInvoice30
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dueDate)), __LINE__);
        }
        $this->dueDate = $dueDate;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \ApptitudeNamespace\StructType\XInvoice30
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get amountExcludingTax value
     * @return float|null
     */
    public function getAmountExcludingTax()
    {
        return $this->amountExcludingTax;
    }
    /**
     * Set amountExcludingTax value
     * @param float $amountExcludingTax
     * @return \ApptitudeNamespace\StructType\XInvoice30
     */
    public function setAmountExcludingTax($amountExcludingTax = null)
    {
        $this->amountExcludingTax = $amountExcludingTax;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \ApptitudeNamespace\StructType\XInvoice30
     */
    public function setTaxAmount($taxAmount = null)
    {
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get outstandingAmount value
     * @return float|null
     */
    public function getOutstandingAmount()
    {
        return $this->outstandingAmount;
    }
    /**
     * Set outstandingAmount value
     * @param float $outstandingAmount
     * @return \ApptitudeNamespace\StructType\XInvoice30
     */
    public function setOutstandingAmount($outstandingAmount = null)
    {
        $this->outstandingAmount = $outstandingAmount;
        return $this;
    }
    /**
     * Get externalUrl value
     * @return string|null
     */
    public function getExternalUrl()
    {
        return $this->externalUrl;
    }
    /**
     * Set externalUrl value
     * @param string $externalUrl
     * @return \ApptitudeNamespace\StructType\XInvoice30
     */
    public function setExternalUrl($externalUrl = null)
    {
        // validation for constraint: string
        if (!is_null($externalUrl) && !is_string($externalUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalUrl)), __LINE__);
        }
        $this->externalUrl = $externalUrl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\XInvoice30
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
