<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xBudgetComponent30 StructType
 * @subpackage Structs
 */
class XBudgetComponent30 extends XObject30
{
    /**
     * The key
     * @var string
     */
    public $key;
    /**
     * The amount
     * @var float
     */
    public $amount;
    /**
     * The actual
     * @var float
     */
    public $actual;
    /**
     * The canceled
     * @var float
     */
    public $canceled;
    /**
     * The season
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $season;
    /**
     * The seasonSortCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $seasonSortCode;
    /**
     * The productGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productGroup;
    /**
     * The category
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $category;
    /**
     * The salesPerson
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salesPerson;
    /**
     * The editable
     * @var bool
     */
    public $editable;
    /**
     * Constructor method for xBudgetComponent30
     * @uses XBudgetComponent30::setKey()
     * @uses XBudgetComponent30::setAmount()
     * @uses XBudgetComponent30::setActual()
     * @uses XBudgetComponent30::setCanceled()
     * @uses XBudgetComponent30::setSeason()
     * @uses XBudgetComponent30::setSeasonSortCode()
     * @uses XBudgetComponent30::setProductGroup()
     * @uses XBudgetComponent30::setCategory()
     * @uses XBudgetComponent30::setSalesPerson()
     * @uses XBudgetComponent30::setEditable()
     * @param string $key
     * @param float $amount
     * @param float $actual
     * @param float $canceled
     * @param string $season
     * @param int $seasonSortCode
     * @param string $productGroup
     * @param string $category
     * @param string $salesPerson
     * @param bool $editable
     */
    public function __construct($key = null, $amount = null, $actual = null, $canceled = null, $season = null, $seasonSortCode = null, $productGroup = null, $category = null, $salesPerson = null, $editable = null)
    {
        $this
            ->setKey($key)
            ->setAmount($amount)
            ->setActual($actual)
            ->setCanceled($canceled)
            ->setSeason($season)
            ->setSeasonSortCode($seasonSortCode)
            ->setProductGroup($productGroup)
            ->setCategory($category)
            ->setSalesPerson($salesPerson)
            ->setEditable($editable);
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \ApptitudeNamespace\StructType\XBudgetComponent30
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \ApptitudeNamespace\StructType\XBudgetComponent30
     */
    public function setAmount($amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get actual value
     * @return float|null
     */
    public function getActual()
    {
        return $this->actual;
    }
    /**
     * Set actual value
     * @param float $actual
     * @return \ApptitudeNamespace\StructType\XBudgetComponent30
     */
    public function setActual($actual = null)
    {
        $this->actual = $actual;
        return $this;
    }
    /**
     * Get canceled value
     * @return float|null
     */
    public function getCanceled()
    {
        return $this->canceled;
    }
    /**
     * Set canceled value
     * @param float $canceled
     * @return \ApptitudeNamespace\StructType\XBudgetComponent30
     */
    public function setCanceled($canceled = null)
    {
        $this->canceled = $canceled;
        return $this;
    }
    /**
     * Get season value
     * @return string|null
     */
    public function getSeason()
    {
        return $this->season;
    }
    /**
     * Set season value
     * @param string $season
     * @return \ApptitudeNamespace\StructType\XBudgetComponent30
     */
    public function setSeason($season = null)
    {
        // validation for constraint: string
        if (!is_null($season) && !is_string($season)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($season)), __LINE__);
        }
        $this->season = $season;
        return $this;
    }
    /**
     * Get seasonSortCode value
     * @return int|null
     */
    public function getSeasonSortCode()
    {
        return $this->seasonSortCode;
    }
    /**
     * Set seasonSortCode value
     * @param int $seasonSortCode
     * @return \ApptitudeNamespace\StructType\XBudgetComponent30
     */
    public function setSeasonSortCode($seasonSortCode = null)
    {
        // validation for constraint: int
        if (!is_null($seasonSortCode) && !is_numeric($seasonSortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seasonSortCode)), __LINE__);
        }
        $this->seasonSortCode = $seasonSortCode;
        return $this;
    }
    /**
     * Get productGroup value
     * @return string|null
     */
    public function getProductGroup()
    {
        return $this->productGroup;
    }
    /**
     * Set productGroup value
     * @param string $productGroup
     * @return \ApptitudeNamespace\StructType\XBudgetComponent30
     */
    public function setProductGroup($productGroup = null)
    {
        // validation for constraint: string
        if (!is_null($productGroup) && !is_string($productGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productGroup)), __LINE__);
        }
        $this->productGroup = $productGroup;
        return $this;
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \ApptitudeNamespace\StructType\XBudgetComponent30
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get salesPerson value
     * @return string|null
     */
    public function getSalesPerson()
    {
        return $this->salesPerson;
    }
    /**
     * Set salesPerson value
     * @param string $salesPerson
     * @return \ApptitudeNamespace\StructType\XBudgetComponent30
     */
    public function setSalesPerson($salesPerson = null)
    {
        // validation for constraint: string
        if (!is_null($salesPerson) && !is_string($salesPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesPerson)), __LINE__);
        }
        $this->salesPerson = $salesPerson;
        return $this;
    }
    /**
     * Get editable value
     * @return bool|null
     */
    public function getEditable()
    {
        return $this->editable;
    }
    /**
     * Set editable value
     * @param bool $editable
     * @return \ApptitudeNamespace\StructType\XBudgetComponent30
     */
    public function setEditable($editable = null)
    {
        // validation for constraint: boolean
        if (!is_null($editable) && !is_bool($editable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($editable)), __LINE__);
        }
        $this->editable = $editable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\XBudgetComponent30
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
