<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for storeProductAccessRules StructType
 * Meta informations extracted from the WSDL
 * - type: tns:storeProductAccessRules
 * @subpackage Structs
 */
class StoreProductAccessRules extends AbstractStructBase
{
    /**
     * The apiKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $apiKey;
    /**
     * The productAccessRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XProductAccessRule30[]
     */
    public $productAccessRule;
    /**
     * Constructor method for storeProductAccessRules
     * @uses StoreProductAccessRules::setApiKey()
     * @uses StoreProductAccessRules::setProductAccessRule()
     * @param string $apiKey
     * @param \ApptitudeNamespace\StructType\XProductAccessRule30[] $productAccessRule
     */
    public function __construct($apiKey = null, array $productAccessRule = array())
    {
        $this
            ->setApiKey($apiKey)
            ->setProductAccessRule($productAccessRule);
    }
    /**
     * Get apiKey value
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \ApptitudeNamespace\StructType\StoreProductAccessRules
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apiKey)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
    /**
     * Get productAccessRule value
     * @return \ApptitudeNamespace\StructType\XProductAccessRule30[]|null
     */
    public function getProductAccessRule()
    {
        return $this->productAccessRule;
    }
    /**
     * Set productAccessRule value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XProductAccessRule30[] $productAccessRule
     * @return \ApptitudeNamespace\StructType\StoreProductAccessRules
     */
    public function setProductAccessRule(array $productAccessRule = array())
    {
        foreach ($productAccessRule as $storeProductAccessRulesProductAccessRuleItem) {
            // validation for constraint: itemType
            if (!$storeProductAccessRulesProductAccessRuleItem instanceof \ApptitudeNamespace\StructType\XProductAccessRule30) {
                throw new \InvalidArgumentException(sprintf('The productAccessRule property can only contain items of \ApptitudeNamespace\StructType\XProductAccessRule30, "%s" given', is_object($storeProductAccessRulesProductAccessRuleItem) ? get_class($storeProductAccessRulesProductAccessRuleItem) : gettype($storeProductAccessRulesProductAccessRuleItem)), __LINE__);
            }
        }
        $this->productAccessRule = $productAccessRule;
        return $this;
    }
    /**
     * Add item to productAccessRule value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XProductAccessRule30 $item
     * @return \ApptitudeNamespace\StructType\StoreProductAccessRules
     */
    public function addToProductAccessRule(\ApptitudeNamespace\StructType\XProductAccessRule30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XProductAccessRule30) {
            throw new \InvalidArgumentException(sprintf('The productAccessRule property can only contain items of \ApptitudeNamespace\StructType\XProductAccessRule30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->productAccessRule[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\StoreProductAccessRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
