<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for storeInvoices StructType
 * Meta informations extracted from the WSDL
 * - type: tns:storeInvoices
 * @subpackage Structs
 */
class StoreInvoices extends AbstractStructBase
{
    /**
     * The apiKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $apiKey;
    /**
     * The invoice
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XInvoice30[]
     */
    public $invoice;
    /**
     * Constructor method for storeInvoices
     * @uses StoreInvoices::setApiKey()
     * @uses StoreInvoices::setInvoice()
     * @param string $apiKey
     * @param \ApptitudeNamespace\StructType\XInvoice30[] $invoice
     */
    public function __construct($apiKey = null, array $invoice = array())
    {
        $this
            ->setApiKey($apiKey)
            ->setInvoice($invoice);
    }
    /**
     * Get apiKey value
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \ApptitudeNamespace\StructType\StoreInvoices
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apiKey)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
    /**
     * Get invoice value
     * @return \ApptitudeNamespace\StructType\XInvoice30[]|null
     */
    public function getInvoice()
    {
        return $this->invoice;
    }
    /**
     * Set invoice value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XInvoice30[] $invoice
     * @return \ApptitudeNamespace\StructType\StoreInvoices
     */
    public function setInvoice(array $invoice = array())
    {
        foreach ($invoice as $storeInvoicesInvoiceItem) {
            // validation for constraint: itemType
            if (!$storeInvoicesInvoiceItem instanceof \ApptitudeNamespace\StructType\XInvoice30) {
                throw new \InvalidArgumentException(sprintf('The invoice property can only contain items of \ApptitudeNamespace\StructType\XInvoice30, "%s" given', is_object($storeInvoicesInvoiceItem) ? get_class($storeInvoicesInvoiceItem) : gettype($storeInvoicesInvoiceItem)), __LINE__);
            }
        }
        $this->invoice = $invoice;
        return $this;
    }
    /**
     * Add item to invoice value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XInvoice30 $item
     * @return \ApptitudeNamespace\StructType\StoreInvoices
     */
    public function addToInvoice(\ApptitudeNamespace\StructType\XInvoice30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XInvoice30) {
            throw new \InvalidArgumentException(sprintf('The invoice property can only contain items of \ApptitudeNamespace\StructType\XInvoice30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->invoice[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\StoreInvoices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
