<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for storeFullInvoiceSetForCustomer StructType
 * Meta informations extracted from the WSDL
 * - type: tns:storeFullInvoiceSetForCustomer
 * @subpackage Structs
 */
class StoreFullInvoiceSetForCustomer extends AbstractStructBase
{
    /**
     * The apiKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $apiKey;
    /**
     * The customerNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerNo;
    /**
     * The invoice
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XInvoice30[]
     */
    public $invoice;
    /**
     * Constructor method for storeFullInvoiceSetForCustomer
     * @uses StoreFullInvoiceSetForCustomer::setApiKey()
     * @uses StoreFullInvoiceSetForCustomer::setCustomerNo()
     * @uses StoreFullInvoiceSetForCustomer::setInvoice()
     * @param string $apiKey
     * @param string $customerNo
     * @param \ApptitudeNamespace\StructType\XInvoice30[] $invoice
     */
    public function __construct($apiKey = null, $customerNo = null, array $invoice = array())
    {
        $this
            ->setApiKey($apiKey)
            ->setCustomerNo($customerNo)
            ->setInvoice($invoice);
    }
    /**
     * Get apiKey value
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \ApptitudeNamespace\StructType\StoreFullInvoiceSetForCustomer
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apiKey)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
    /**
     * Get customerNo value
     * @return string|null
     */
    public function getCustomerNo()
    {
        return $this->customerNo;
    }
    /**
     * Set customerNo value
     * @param string $customerNo
     * @return \ApptitudeNamespace\StructType\StoreFullInvoiceSetForCustomer
     */
    public function setCustomerNo($customerNo = null)
    {
        // validation for constraint: string
        if (!is_null($customerNo) && !is_string($customerNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerNo)), __LINE__);
        }
        $this->customerNo = $customerNo;
        return $this;
    }
    /**
     * Get invoice value
     * @return \ApptitudeNamespace\StructType\XInvoice30[]|null
     */
    public function getInvoice()
    {
        return $this->invoice;
    }
    /**
     * Set invoice value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XInvoice30[] $invoice
     * @return \ApptitudeNamespace\StructType\StoreFullInvoiceSetForCustomer
     */
    public function setInvoice(array $invoice = array())
    {
        foreach ($invoice as $storeFullInvoiceSetForCustomerInvoiceItem) {
            // validation for constraint: itemType
            if (!$storeFullInvoiceSetForCustomerInvoiceItem instanceof \ApptitudeNamespace\StructType\XInvoice30) {
                throw new \InvalidArgumentException(sprintf('The invoice property can only contain items of \ApptitudeNamespace\StructType\XInvoice30, "%s" given', is_object($storeFullInvoiceSetForCustomerInvoiceItem) ? get_class($storeFullInvoiceSetForCustomerInvoiceItem) : gettype($storeFullInvoiceSetForCustomerInvoiceItem)), __LINE__);
            }
        }
        $this->invoice = $invoice;
        return $this;
    }
    /**
     * Add item to invoice value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XInvoice30 $item
     * @return \ApptitudeNamespace\StructType\StoreFullInvoiceSetForCustomer
     */
    public function addToInvoice(\ApptitudeNamespace\StructType\XInvoice30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XInvoice30) {
            throw new \InvalidArgumentException(sprintf('The invoice property can only contain items of \ApptitudeNamespace\StructType\XInvoice30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->invoice[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\StoreFullInvoiceSetForCustomer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
