<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for storeFullCustomerAccessSet StructType
 * Meta informations extracted from the WSDL
 * - type: tns:storeFullCustomerAccessSet
 * @subpackage Structs
 */
class StoreFullCustomerAccessSet extends AbstractStructBase
{
    /**
     * The apiKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $apiKey;
    /**
     * The agentCustomerAccessRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XAgentCustomerAccess30[]
     */
    public $agentCustomerAccessRecord;
    /**
     * Constructor method for storeFullCustomerAccessSet
     * @uses StoreFullCustomerAccessSet::setApiKey()
     * @uses StoreFullCustomerAccessSet::setAgentCustomerAccessRecord()
     * @param string $apiKey
     * @param \ApptitudeNamespace\StructType\XAgentCustomerAccess30[] $agentCustomerAccessRecord
     */
    public function __construct($apiKey = null, array $agentCustomerAccessRecord = array())
    {
        $this
            ->setApiKey($apiKey)
            ->setAgentCustomerAccessRecord($agentCustomerAccessRecord);
    }
    /**
     * Get apiKey value
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \ApptitudeNamespace\StructType\StoreFullCustomerAccessSet
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apiKey)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
    /**
     * Get agentCustomerAccessRecord value
     * @return \ApptitudeNamespace\StructType\XAgentCustomerAccess30[]|null
     */
    public function getAgentCustomerAccessRecord()
    {
        return $this->agentCustomerAccessRecord;
    }
    /**
     * Set agentCustomerAccessRecord value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XAgentCustomerAccess30[] $agentCustomerAccessRecord
     * @return \ApptitudeNamespace\StructType\StoreFullCustomerAccessSet
     */
    public function setAgentCustomerAccessRecord(array $agentCustomerAccessRecord = array())
    {
        foreach ($agentCustomerAccessRecord as $storeFullCustomerAccessSetAgentCustomerAccessRecordItem) {
            // validation for constraint: itemType
            if (!$storeFullCustomerAccessSetAgentCustomerAccessRecordItem instanceof \ApptitudeNamespace\StructType\XAgentCustomerAccess30) {
                throw new \InvalidArgumentException(sprintf('The agentCustomerAccessRecord property can only contain items of \ApptitudeNamespace\StructType\XAgentCustomerAccess30, "%s" given', is_object($storeFullCustomerAccessSetAgentCustomerAccessRecordItem) ? get_class($storeFullCustomerAccessSetAgentCustomerAccessRecordItem) : gettype($storeFullCustomerAccessSetAgentCustomerAccessRecordItem)), __LINE__);
            }
        }
        $this->agentCustomerAccessRecord = $agentCustomerAccessRecord;
        return $this;
    }
    /**
     * Add item to agentCustomerAccessRecord value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XAgentCustomerAccess30 $item
     * @return \ApptitudeNamespace\StructType\StoreFullCustomerAccessSet
     */
    public function addToAgentCustomerAccessRecord(\ApptitudeNamespace\StructType\XAgentCustomerAccess30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XAgentCustomerAccess30) {
            throw new \InvalidArgumentException(sprintf('The agentCustomerAccessRecord property can only contain items of \ApptitudeNamespace\StructType\XAgentCustomerAccess30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->agentCustomerAccessRecord[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\StoreFullCustomerAccessSet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
