<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deleteProducts StructType
 * Meta informations extracted from the WSDL
 * - type: tns:deleteProducts
 * @subpackage Structs
 */
class DeleteProducts extends AbstractStructBase
{
    /**
     * The apiKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $apiKey;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ApptitudeNamespace\StructType\XProduct30[]
     */
    public $product;
    /**
     * Constructor method for deleteProducts
     * @uses DeleteProducts::setApiKey()
     * @uses DeleteProducts::setProduct()
     * @param string $apiKey
     * @param \ApptitudeNamespace\StructType\XProduct30[] $product
     */
    public function __construct($apiKey = null, array $product = array())
    {
        $this
            ->setApiKey($apiKey)
            ->setProduct($product);
    }
    /**
     * Get apiKey value
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \ApptitudeNamespace\StructType\DeleteProducts
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apiKey)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
    /**
     * Get product value
     * @return \ApptitudeNamespace\StructType\XProduct30[]|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XProduct30[] $product
     * @return \ApptitudeNamespace\StructType\DeleteProducts
     */
    public function setProduct(array $product = array())
    {
        foreach ($product as $deleteProductsProductItem) {
            // validation for constraint: itemType
            if (!$deleteProductsProductItem instanceof \ApptitudeNamespace\StructType\XProduct30) {
                throw new \InvalidArgumentException(sprintf('The product property can only contain items of \ApptitudeNamespace\StructType\XProduct30, "%s" given', is_object($deleteProductsProductItem) ? get_class($deleteProductsProductItem) : gettype($deleteProductsProductItem)), __LINE__);
            }
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Add item to product value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XProduct30 $item
     * @return \ApptitudeNamespace\StructType\DeleteProducts
     */
    public function addToProduct(\ApptitudeNamespace\StructType\XProduct30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XProduct30) {
            throw new \InvalidArgumentException(sprintf('The product property can only contain items of \ApptitudeNamespace\StructType\XProduct30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->product[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\DeleteProducts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
