<?php

namespace ApptitudeNamespace\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\GetOrders $parameters
     * @return \ApptitudeNamespace\StructType\GetOrdersResponse|bool
     */
    public function getOrders(\ApptitudeNamespace\StructType\GetOrders $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUnprocessedOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\GetUnprocessedOrders $parameters
     * @return \ApptitudeNamespace\StructType\GetUnprocessedOrdersResponse|bool
     */
    public function getUnprocessedOrders(\ApptitudeNamespace\StructType\GetUnprocessedOrders $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getUnprocessedOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAllProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\GetAllProducts $parameters
     * @return \ApptitudeNamespace\StructType\GetAllProductsResponse|bool
     */
    public function getAllProducts(\ApptitudeNamespace\StructType\GetAllProducts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getAllProducts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ApptitudeNamespace\StructType\GetInfo $parameters
     * @return \ApptitudeNamespace\StructType\GetInfoResponse|bool
     */
    public function getInfo(\ApptitudeNamespace\StructType\GetInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ApptitudeNamespace\StructType\GetAllProductsResponse|\ApptitudeNamespace\StructType\GetInfoResponse|\ApptitudeNamespace\StructType\GetOrdersResponse|\ApptitudeNamespace\StructType\GetUnprocessedOrdersResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
