<?php

namespace ApptitudeNamespace\EnumType;

/**
 * This class stands for xUserType30 EnumType
 * @subpackage Enumerations
 */
class XUserType30
{
    /**
     * Constant for value 'PARTNER'
     * @return string 'PARTNER'
     */
    const VALUE_PARTNER = 'PARTNER';
    /**
     * Constant for value 'COMPANY_ADMIN'
     * @return string 'COMPANY_ADMIN'
     */
    const VALUE_COMPANY_ADMIN = 'COMPANY_ADMIN';
    /**
     * Constant for value 'COMPANY_ADMIN_BACKEND'
     * @return string 'COMPANY_ADMIN_BACKEND'
     */
    const VALUE_COMPANY_ADMIN_BACKEND = 'COMPANY_ADMIN_BACKEND';
    /**
     * Constant for value 'COMPANY_SALESREP'
     * @return string 'COMPANY_SALESREP'
     */
    const VALUE_COMPANY_SALESREP = 'COMPANY_SALESREP';
    /**
     * Constant for value 'SALES_AGENT'
     * @return string 'SALES_AGENT'
     */
    const VALUE_SALES_AGENT = 'SALES_AGENT';
    /**
     * Constant for value 'SALES_AGENT_WEB'
     * @return string 'SALES_AGENT_WEB'
     */
    const VALUE_SALES_AGENT_WEB = 'SALES_AGENT_WEB';
    /**
     * Constant for value 'RETAILER'
     * @return string 'RETAILER'
     */
    const VALUE_RETAILER = 'RETAILER';
    /**
     * Constant for value 'RETAILER_INSTOREMODE'
     * @return string 'RETAILER_INSTOREMODE'
     */
    const VALUE_RETAILER_INSTOREMODE = 'RETAILER_INSTOREMODE';
    /**
     * Constant for value 'RETAILER_WEB'
     * @return string 'RETAILER_WEB'
     */
    const VALUE_RETAILER_WEB = 'RETAILER_WEB';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PARTNER
     * @uses self::VALUE_COMPANY_ADMIN
     * @uses self::VALUE_COMPANY_ADMIN_BACKEND
     * @uses self::VALUE_COMPANY_SALESREP
     * @uses self::VALUE_SALES_AGENT
     * @uses self::VALUE_SALES_AGENT_WEB
     * @uses self::VALUE_RETAILER
     * @uses self::VALUE_RETAILER_INSTOREMODE
     * @uses self::VALUE_RETAILER_WEB
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PARTNER,
            self::VALUE_COMPANY_ADMIN,
            self::VALUE_COMPANY_ADMIN_BACKEND,
            self::VALUE_COMPANY_SALESREP,
            self::VALUE_SALES_AGENT,
            self::VALUE_SALES_AGENT_WEB,
            self::VALUE_RETAILER,
            self::VALUE_RETAILER_INSTOREMODE,
            self::VALUE_RETAILER_WEB,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
