<?php

namespace ApptitudeNamespace\EnumType;

/**
 * This class stands for xRuleEvaluationMethod30 EnumType
 * @subpackage Enumerations
 */
class XRuleEvaluationMethod30
{
    /**
     * Constant for value 'EVALUATE_BASED_ON_TODAY'
     * @return string 'EVALUATE_BASED_ON_TODAY'
     */
    const VALUE_EVALUATE_BASED_ON_TODAY = 'EVALUATE_BASED_ON_TODAY';
    /**
     * Constant for value 'EVALUATE_BASED_ON_DELIVERY_DATE'
     * @return string 'EVALUATE_BASED_ON_DELIVERY_DATE'
     */
    const VALUE_EVALUATE_BASED_ON_DELIVERY_DATE = 'EVALUATE_BASED_ON_DELIVERY_DATE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EVALUATE_BASED_ON_TODAY
     * @uses self::VALUE_EVALUATE_BASED_ON_DELIVERY_DATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EVALUATE_BASED_ON_TODAY,
            self::VALUE_EVALUATE_BASED_ON_DELIVERY_DATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
