<?php

namespace ApptitudeNamespace\EnumType;

/**
 * This class stands for xOrderLineType30 EnumType
 * @subpackage Enumerations
 */
class XOrderLineType30
{
    /**
     * Constant for value 'STOCK_ORDER'
     * @return string 'STOCK_ORDER'
     */
    const VALUE_STOCK_ORDER = 'STOCK_ORDER';
    /**
     * Constant for value 'PRE_ORDER'
     * @return string 'PRE_ORDER'
     */
    const VALUE_PRE_ORDER = 'PRE_ORDER';
    /**
     * Constant for value 'RETURN_ORDER'
     * @return string 'RETURN_ORDER'
     */
    const VALUE_RETURN_ORDER = 'RETURN_ORDER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STOCK_ORDER
     * @uses self::VALUE_PRE_ORDER
     * @uses self::VALUE_RETURN_ORDER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STOCK_ORDER,
            self::VALUE_PRE_ORDER,
            self::VALUE_RETURN_ORDER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
