<?php

namespace ApptitudeNamespace\EnumType;

/**
 * This class stands for xMediumType30 EnumType
 * @subpackage Enumerations
 */
class XMediumType30
{
    /**
     * Constant for value 'IMAGE_PRIMARY'
     * @return string 'IMAGE_PRIMARY'
     */
    const VALUE_IMAGE_PRIMARY = 'IMAGE_PRIMARY';
    /**
     * Constant for value 'IMAGE_SWATCH'
     * @return string 'IMAGE_SWATCH'
     */
    const VALUE_IMAGE_SWATCH = 'IMAGE_SWATCH';
    /**
     * Constant for value 'IMAGE_MODEL'
     * @return string 'IMAGE_MODEL'
     */
    const VALUE_IMAGE_MODEL = 'IMAGE_MODEL';
    /**
     * Constant for value 'IMAGE_MODEL_BACK'
     * @return string 'IMAGE_MODEL_BACK'
     */
    const VALUE_IMAGE_MODEL_BACK = 'IMAGE_MODEL_BACK';
    /**
     * Constant for value 'IMAGE_LEFT'
     * @return string 'IMAGE_LEFT'
     */
    const VALUE_IMAGE_LEFT = 'IMAGE_LEFT';
    /**
     * Constant for value 'IMAGE_RIGHT'
     * @return string 'IMAGE_RIGHT'
     */
    const VALUE_IMAGE_RIGHT = 'IMAGE_RIGHT';
    /**
     * Constant for value 'IMAGE_BACK'
     * @return string 'IMAGE_BACK'
     */
    const VALUE_IMAGE_BACK = 'IMAGE_BACK';
    /**
     * Constant for value 'IMAGE_PACK'
     * @return string 'IMAGE_PACK'
     */
    const VALUE_IMAGE_PACK = 'IMAGE_PACK';
    /**
     * Constant for value 'IMAGE_TOP'
     * @return string 'IMAGE_TOP'
     */
    const VALUE_IMAGE_TOP = 'IMAGE_TOP';
    /**
     * Constant for value 'IMAGE_BOTTOM'
     * @return string 'IMAGE_BOTTOM'
     */
    const VALUE_IMAGE_BOTTOM = 'IMAGE_BOTTOM';
    /**
     * Constant for value 'IMAGE_FIT'
     * @return string 'IMAGE_FIT'
     */
    const VALUE_IMAGE_FIT = 'IMAGE_FIT';
    /**
     * Constant for value 'IMAGE_STAMP_LEFT'
     * @return string 'IMAGE_STAMP_LEFT'
     */
    const VALUE_IMAGE_STAMP_LEFT = 'IMAGE_STAMP_LEFT';
    /**
     * Constant for value 'IMAGE_STAMP_RIGHT'
     * @return string 'IMAGE_STAMP_RIGHT'
     */
    const VALUE_IMAGE_STAMP_RIGHT = 'IMAGE_STAMP_RIGHT';
    /**
     * Constant for value 'VIDEO'
     * @return string 'VIDEO'
     */
    const VALUE_VIDEO = 'VIDEO';
    /**
     * Constant for value 'VIDEO_MODEL'
     * @return string 'VIDEO_MODEL'
     */
    const VALUE_VIDEO_MODEL = 'VIDEO_MODEL';
    /**
     * Constant for value 'VIDEO_MODEL_LEAD_IN'
     * @return string 'VIDEO_MODEL_LEAD_IN'
     */
    const VALUE_VIDEO_MODEL_LEAD_IN = 'VIDEO_MODEL_LEAD_IN';
    /**
     * Constant for value 'VIDEO_MODEL_LEAD_OUT'
     * @return string 'VIDEO_MODEL_LEAD_OUT'
     */
    const VALUE_VIDEO_MODEL_LEAD_OUT = 'VIDEO_MODEL_LEAD_OUT';
    /**
     * Constant for value 'HTML'
     * @return string 'HTML'
     */
    const VALUE_HTML = 'HTML';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IMAGE_PRIMARY
     * @uses self::VALUE_IMAGE_SWATCH
     * @uses self::VALUE_IMAGE_MODEL
     * @uses self::VALUE_IMAGE_MODEL_BACK
     * @uses self::VALUE_IMAGE_LEFT
     * @uses self::VALUE_IMAGE_RIGHT
     * @uses self::VALUE_IMAGE_BACK
     * @uses self::VALUE_IMAGE_PACK
     * @uses self::VALUE_IMAGE_TOP
     * @uses self::VALUE_IMAGE_BOTTOM
     * @uses self::VALUE_IMAGE_FIT
     * @uses self::VALUE_IMAGE_STAMP_LEFT
     * @uses self::VALUE_IMAGE_STAMP_RIGHT
     * @uses self::VALUE_VIDEO
     * @uses self::VALUE_VIDEO_MODEL
     * @uses self::VALUE_VIDEO_MODEL_LEAD_IN
     * @uses self::VALUE_VIDEO_MODEL_LEAD_OUT
     * @uses self::VALUE_HTML
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IMAGE_PRIMARY,
            self::VALUE_IMAGE_SWATCH,
            self::VALUE_IMAGE_MODEL,
            self::VALUE_IMAGE_MODEL_BACK,
            self::VALUE_IMAGE_LEFT,
            self::VALUE_IMAGE_RIGHT,
            self::VALUE_IMAGE_BACK,
            self::VALUE_IMAGE_PACK,
            self::VALUE_IMAGE_TOP,
            self::VALUE_IMAGE_BOTTOM,
            self::VALUE_IMAGE_FIT,
            self::VALUE_IMAGE_STAMP_LEFT,
            self::VALUE_IMAGE_STAMP_RIGHT,
            self::VALUE_VIDEO,
            self::VALUE_VIDEO_MODEL,
            self::VALUE_VIDEO_MODEL_LEAD_IN,
            self::VALUE_VIDEO_MODEL_LEAD_OUT,
            self::VALUE_HTML,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
