<?php

namespace ApptitudeNamespace\EnumType;

/**
 * This class stands for xCustomerStatus30 EnumType
 * @subpackage Enumerations
 */
class XCustomerStatus30
{
    /**
     * Constant for value 'ACTIVE'
     * @return string 'ACTIVE'
     */
    const VALUE_ACTIVE = 'ACTIVE';
    /**
     * Constant for value 'WARNING'
     * @return string 'WARNING'
     */
    const VALUE_WARNING = 'WARNING';
    /**
     * Constant for value 'BLOCKED'
     * @return string 'BLOCKED'
     */
    const VALUE_BLOCKED = 'BLOCKED';
    /**
     * Constant for value 'BLOCKED_FOR_ORDERING'
     * @return string 'BLOCKED_FOR_ORDERING'
     */
    const VALUE_BLOCKED_FOR_ORDERING = 'BLOCKED_FOR_ORDERING';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_WARNING
     * @uses self::VALUE_BLOCKED
     * @uses self::VALUE_BLOCKED_FOR_ORDERING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVE,
            self::VALUE_WARNING,
            self::VALUE_BLOCKED,
            self::VALUE_BLOCKED_FOR_ORDERING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
