<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Submit ServiceType
 */
$submit = new \ServiceType\Submit($options);
$submit->setSoapHeaderSessionHeaderValue($SessionHeaderValue);
/**
 * Sample call for Submit operation/method
 */
if ($submit->Submit(new \StructType\Submit()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for SubmitTransport operation/method
 */
if ($submit->SubmitTransport(new \StructType\SubmitTransport()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for SubmitXML operation/method
 */
if ($submit->SubmitXML(new \StructType\SubmitXML()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Samples for Extract ServiceType
 */
$extract = new \ServiceType\Extract($options);
$extract->setSoapHeaderSessionHeaderValue($SessionHeaderValue);
$extract->setSoapHeaderExtractionHeaderValue($ExtractionHeaderValue);
/**
 * Sample call for ExtractFirst operation/method
 */
if ($extract->ExtractFirst(new \StructType\ExtractFirst()) !== false) {
    print_r($extract->getResult());
} else {
    print_r($extract->getLastError());
}
/**
 * Sample call for ExtractNext operation/method
 */
if ($extract->ExtractNext(new \StructType\ExtractNext()) !== false) {
    print_r($extract->getResult());
} else {
    print_r($extract->getLastError());
}
/**
 * Samples for Convert ServiceType
 */
$convert = new \ServiceType\Convert($options);
$convert->setSoapHeaderSessionHeaderValue($SessionHeaderValue);
/**
 * Sample call for ConvertFile operation/method
 */
if ($convert->ConvertFile(new \StructType\ConvertFile()) !== false) {
    print_r($convert->getResult());
} else {
    print_r($convert->getLastError());
}
/**
 * Samples for Upload ServiceType
 */
$upload = new \ServiceType\Upload($options);
$upload->setSoapHeaderSessionHeaderValue($SessionHeaderValue);
/**
 * Sample call for UploadFile operation/method
 */
if ($upload->UploadFile(new \StructType\UploadFile()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Sample call for UploadFileAppend operation/method
 */
if ($upload->UploadFileAppend(new \StructType\UploadFileAppend()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Samples for Download ServiceType
 */
$download = new \ServiceType\Download($options);
$download->setSoapHeaderSessionHeaderValue($SessionHeaderValue);
/**
 * Sample call for DownloadFile operation/method
 */
if ($download->DownloadFile(new \StructType\DownloadFile()) !== false) {
    print_r($download->getResult());
} else {
    print_r($download->getLastError());
}
/**
 * Samples for Register ServiceType
 */
$register = new \ServiceType\Register($options);
$register->setSoapHeaderSessionHeaderValue($SessionHeaderValue);
/**
 * Sample call for RegisterResource operation/method
 */
if ($register->RegisterResource(new \StructType\RegisterResource()) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \ServiceType\_List($options);
$list->setSoapHeaderSessionHeaderValue($SessionHeaderValue);
/**
 * Sample call for ListResources operation/method
 */
if ($list->ListResources(new \StructType\ListResources()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
$delete->setSoapHeaderSessionHeaderValue($SessionHeaderValue);
/**
 * Sample call for DeleteResource operation/method
 */
if ($delete->DeleteResource(new \StructType\DeleteResource()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Retrieve ServiceType
 */
$retrieve = new \ServiceType\Retrieve($options);
$retrieve->setSoapHeaderSessionHeaderValue($SessionHeaderValue);
/**
 * Sample call for RetrieveResource operation/method
 */
if ($retrieve->RetrieveResource(new \StructType\RetrieveResource()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
