<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XMLDescription StructType
 * @subpackage Structs
 */
class XMLDescription extends AbstractStructBase
{
    /**
     * The xmlFile
     * @var \StructType\WSFile
     */
    public $xmlFile;
    /**
     * The nAttachments
     * @var int
     */
    public $nAttachments;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - SizeIs: nAttachments
     * - nillable: true
     * @var \StructType\Attachments
     */
    public $attachments;
    /**
     * Constructor method for XMLDescription
     * @uses XMLDescription::setXmlFile()
     * @uses XMLDescription::setNAttachments()
     * @uses XMLDescription::setAttachments()
     * @param \StructType\WSFile $xmlFile
     * @param int $nAttachments
     * @param \StructType\Attachments $attachments
     */
    public function __construct(\StructType\WSFile $xmlFile = null, $nAttachments = null, \StructType\Attachments $attachments = null)
    {
        $this
            ->setXmlFile($xmlFile)
            ->setNAttachments($nAttachments)
            ->setAttachments($attachments);
    }
    /**
     * Get xmlFile value
     * @return \StructType\WSFile|null
     */
    public function getXmlFile()
    {
        return $this->xmlFile;
    }
    /**
     * Set xmlFile value
     * @param \StructType\WSFile $xmlFile
     * @return \StructType\XMLDescription
     */
    public function setXmlFile(\StructType\WSFile $xmlFile = null)
    {
        $this->xmlFile = $xmlFile;
        return $this;
    }
    /**
     * Get nAttachments value
     * @return int|null
     */
    public function getNAttachments()
    {
        return $this->nAttachments;
    }
    /**
     * Set nAttachments value
     * @param int $nAttachments
     * @return \StructType\XMLDescription
     */
    public function setNAttachments($nAttachments = null)
    {
        // validation for constraint: int
        if (!is_null($nAttachments) && !is_numeric($nAttachments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nAttachments)), __LINE__);
        }
        $this->nAttachments = $nAttachments;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\Attachments|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @param \StructType\Attachments $attachments
     * @return \StructType\XMLDescription
     */
    public function setAttachments(\StructType\Attachments $attachments = null)
    {
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XMLDescription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
