<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadFile StructType
 * @subpackage Structs
 */
class UploadFile extends AbstractStructBase
{
    /**
     * The fileContent
     * @var string
     */
    public $fileContent;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * Constructor method for UploadFile
     * @uses UploadFile::setFileContent()
     * @uses UploadFile::setName()
     * @param string $fileContent
     * @param string $name
     */
    public function __construct($fileContent = null, $name = null)
    {
        $this
            ->setFileContent($fileContent)
            ->setName($name);
    }
    /**
     * Get fileContent value
     * @return string|null
     */
    public function getFileContent()
    {
        return $this->fileContent;
    }
    /**
     * Set fileContent value
     * @param string $fileContent
     * @return \StructType\UploadFile
     */
    public function setFileContent($fileContent = null)
    {
        // validation for constraint: string
        if (!is_null($fileContent) && !is_string($fileContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileContent)), __LINE__);
        }
        $this->fileContent = $fileContent;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\UploadFile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UploadFile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
