<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit StructType
 * @subpackage Structs
 */
class Submit extends AbstractStructBase
{
    /**
     * The subject
     * @var string
     */
    public $subject;
    /**
     * The document
     * @var \StructType\BusinessData
     */
    public $document;
    /**
     * The rules
     * @var \StructType\BusinessRules
     */
    public $rules;
    /**
     * Constructor method for Submit
     * @uses Submit::setSubject()
     * @uses Submit::setDocument()
     * @uses Submit::setRules()
     * @param string $subject
     * @param \StructType\BusinessData $document
     * @param \StructType\BusinessRules $rules
     */
    public function __construct($subject = null, \StructType\BusinessData $document = null, \StructType\BusinessRules $rules = null)
    {
        $this
            ->setSubject($subject)
            ->setDocument($document)
            ->setRules($rules);
    }
    /**
     * Get subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->subject;
    }
    /**
     * Set subject value
     * @param string $subject
     * @return \StructType\Submit
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->subject = $subject;
        return $this;
    }
    /**
     * Get document value
     * @return \StructType\BusinessData|null
     */
    public function getDocument()
    {
        return $this->document;
    }
    /**
     * Set document value
     * @param \StructType\BusinessData $document
     * @return \StructType\Submit
     */
    public function setDocument(\StructType\BusinessData $document = null)
    {
        $this->document = $document;
        return $this;
    }
    /**
     * Get rules value
     * @return \StructType\BusinessRules|null
     */
    public function getRules()
    {
        return $this->rules;
    }
    /**
     * Set rules value
     * @param \StructType\BusinessRules $rules
     * @return \StructType\Submit
     */
    public function setRules(\StructType\BusinessRules $rules = null)
    {
        $this->rules = $rules;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Submit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
