<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubNode StructType
 * @subpackage Structs
 */
class SubNode extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The relativeName
     * @var string
     */
    public $relativeName;
    /**
     * The nSubnodes
     * @var int
     */
    public $nSubnodes;
    /**
     * The subNodes
     * Meta informations extracted from the WSDL
     * - SizeIs: nSubnodes
     * - nillable: true
     * @var \StructType\SubNodes_1
     */
    public $subNodes;
    /**
     * The nVars
     * @var int
     */
    public $nVars;
    /**
     * The vars
     * Meta informations extracted from the WSDL
     * - SizeIs: nVars
     * - nillable: true
     * @var \StructType\Vars
     */
    public $vars;
    /**
     * Constructor method for SubNode
     * @uses SubNode::setName()
     * @uses SubNode::setRelativeName()
     * @uses SubNode::setNSubnodes()
     * @uses SubNode::setSubNodes()
     * @uses SubNode::setNVars()
     * @uses SubNode::setVars()
     * @param string $name
     * @param string $relativeName
     * @param int $nSubnodes
     * @param \StructType\SubNodes_1 $subNodes
     * @param int $nVars
     * @param \StructType\Vars $vars
     */
    public function __construct($name = null, $relativeName = null, $nSubnodes = null, \StructType\SubNodes_1 $subNodes = null, $nVars = null, \StructType\Vars $vars = null)
    {
        $this
            ->setName($name)
            ->setRelativeName($relativeName)
            ->setNSubnodes($nSubnodes)
            ->setSubNodes($subNodes)
            ->setNVars($nVars)
            ->setVars($vars);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\SubNode
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get relativeName value
     * @return string|null
     */
    public function getRelativeName()
    {
        return $this->relativeName;
    }
    /**
     * Set relativeName value
     * @param string $relativeName
     * @return \StructType\SubNode
     */
    public function setRelativeName($relativeName = null)
    {
        // validation for constraint: string
        if (!is_null($relativeName) && !is_string($relativeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relativeName)), __LINE__);
        }
        $this->relativeName = $relativeName;
        return $this;
    }
    /**
     * Get nSubnodes value
     * @return int|null
     */
    public function getNSubnodes()
    {
        return $this->nSubnodes;
    }
    /**
     * Set nSubnodes value
     * @param int $nSubnodes
     * @return \StructType\SubNode
     */
    public function setNSubnodes($nSubnodes = null)
    {
        // validation for constraint: int
        if (!is_null($nSubnodes) && !is_numeric($nSubnodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nSubnodes)), __LINE__);
        }
        $this->nSubnodes = $nSubnodes;
        return $this;
    }
    /**
     * Get subNodes value
     * @return \StructType\SubNodes_1|null
     */
    public function getSubNodes()
    {
        return $this->subNodes;
    }
    /**
     * Set subNodes value
     * @param \StructType\SubNodes_1 $subNodes
     * @return \StructType\SubNode
     */
    public function setSubNodes(\StructType\SubNodes_1 $subNodes = null)
    {
        $this->subNodes = $subNodes;
        return $this;
    }
    /**
     * Get nVars value
     * @return int|null
     */
    public function getNVars()
    {
        return $this->nVars;
    }
    /**
     * Set nVars value
     * @param int $nVars
     * @return \StructType\SubNode
     */
    public function setNVars($nVars = null)
    {
        // validation for constraint: int
        if (!is_null($nVars) && !is_numeric($nVars)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nVars)), __LINE__);
        }
        $this->nVars = $nVars;
        return $this;
    }
    /**
     * Get vars value
     * @return \StructType\Vars|null
     */
    public function getVars()
    {
        return $this->vars;
    }
    /**
     * Set vars value
     * @param \StructType\Vars $vars
     * @return \StructType\SubNode
     */
    public function setVars(\StructType\Vars $vars = null)
    {
        $this->vars = $vars;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubNode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
