<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resources StructType
 * @subpackage Structs
 */
class Resources extends AbstractStructBase
{
    /**
     * The nResources
     * @var int
     */
    public $nResources;
    /**
     * The resources
     * Meta informations extracted from the WSDL
     * - SizeIs: nResources
     * - nillable: true
     * @var \StructType\Resources_1
     */
    public $resources;
    /**
     * Constructor method for Resources
     * @uses Resources::setNResources()
     * @uses Resources::setResources()
     * @param int $nResources
     * @param \StructType\Resources_1 $resources
     */
    public function __construct($nResources = null, \StructType\Resources_1 $resources = null)
    {
        $this
            ->setNResources($nResources)
            ->setResources($resources);
    }
    /**
     * Get nResources value
     * @return int|null
     */
    public function getNResources()
    {
        return $this->nResources;
    }
    /**
     * Set nResources value
     * @param int $nResources
     * @return \StructType\Resources
     */
    public function setNResources($nResources = null)
    {
        // validation for constraint: int
        if (!is_null($nResources) && !is_numeric($nResources)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nResources)), __LINE__);
        }
        $this->nResources = $nResources;
        return $this;
    }
    /**
     * Get resources value
     * @return \StructType\Resources_1|null
     */
    public function getResources()
    {
        return $this->resources;
    }
    /**
     * Set resources value
     * @param \StructType\Resources_1 $resources
     * @return \StructType\Resources
     */
    public function setResources(\StructType\Resources_1 $resources = null)
    {
        $this->resources = $resources;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Resources
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
