<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisterResource StructType
 * @subpackage Structs
 */
class RegisterResource extends AbstractStructBase
{
    /**
     * The resource
     * @var \StructType\WSFile
     */
    public $resource;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The published
     * @var bool
     */
    public $published;
    /**
     * The overwritePrevious
     * @var bool
     */
    public $overwritePrevious;
    /**
     * Constructor method for RegisterResource
     * @uses RegisterResource::setResource()
     * @uses RegisterResource::setType()
     * @uses RegisterResource::setPublished()
     * @uses RegisterResource::setOverwritePrevious()
     * @param \StructType\WSFile $resource
     * @param string $type
     * @param bool $published
     * @param bool $overwritePrevious
     */
    public function __construct(\StructType\WSFile $resource = null, $type = null, $published = null, $overwritePrevious = null)
    {
        $this
            ->setResource($resource)
            ->setType($type)
            ->setPublished($published)
            ->setOverwritePrevious($overwritePrevious);
    }
    /**
     * Get resource value
     * @return \StructType\WSFile|null
     */
    public function getResource()
    {
        return $this->resource;
    }
    /**
     * Set resource value
     * @param \StructType\WSFile $resource
     * @return \StructType\RegisterResource
     */
    public function setResource(\StructType\WSFile $resource = null)
    {
        $this->resource = $resource;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\RESOURCE_TYPE::valueIsValid()
     * @uses \EnumType\RESOURCE_TYPE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\RegisterResource
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RESOURCE_TYPE::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\RESOURCE_TYPE::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get published value
     * @return bool|null
     */
    public function getPublished()
    {
        return $this->published;
    }
    /**
     * Set published value
     * @param bool $published
     * @return \StructType\RegisterResource
     */
    public function setPublished($published = null)
    {
        // validation for constraint: boolean
        if (!is_null($published) && !is_bool($published)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($published)), __LINE__);
        }
        $this->published = $published;
        return $this;
    }
    /**
     * Get overwritePrevious value
     * @return bool|null
     */
    public function getOverwritePrevious()
    {
        return $this->overwritePrevious;
    }
    /**
     * Set overwritePrevious value
     * @param bool $overwritePrevious
     * @return \StructType\RegisterResource
     */
    public function setOverwritePrevious($overwritePrevious = null)
    {
        // validation for constraint: boolean
        if (!is_null($overwritePrevious) && !is_bool($overwritePrevious)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($overwritePrevious)), __LINE__);
        }
        $this->overwritePrevious = $overwritePrevious;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegisterResource
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
