<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListResources StructType
 * @subpackage Structs
 */
class ListResources extends AbstractStructBase
{
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The published
     * @var bool
     */
    public $published;
    /**
     * Constructor method for ListResources
     * @uses ListResources::setType()
     * @uses ListResources::setPublished()
     * @param string $type
     * @param bool $published
     */
    public function __construct($type = null, $published = null)
    {
        $this
            ->setType($type)
            ->setPublished($published);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\RESOURCE_TYPE::valueIsValid()
     * @uses \EnumType\RESOURCE_TYPE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\ListResources
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RESOURCE_TYPE::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\RESOURCE_TYPE::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get published value
     * @return bool|null
     */
    public function getPublished()
    {
        return $this->published;
    }
    /**
     * Set published value
     * @param bool $published
     * @return \StructType\ListResources
     */
    public function setPublished($published = null)
    {
        // validation for constraint: boolean
        if (!is_null($published) && !is_bool($published)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($published)), __LINE__);
        }
        $this->published = $published;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ListResources
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
