<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtractionResult StructType
 * @subpackage Structs
 */
class ExtractionResult extends AbstractStructBase
{
    /**
     * The noMoreItems
     * @var bool
     */
    public $noMoreItems;
    /**
     * The nTransports
     * @var int
     */
    public $nTransports;
    /**
     * The transports
     * Meta informations extracted from the WSDL
     * - SizeIs: nTransports
     * - nillable: true
     * @var \StructType\Transports
     */
    public $transports;
    /**
     * Constructor method for ExtractionResult
     * @uses ExtractionResult::setNoMoreItems()
     * @uses ExtractionResult::setNTransports()
     * @uses ExtractionResult::setTransports()
     * @param bool $noMoreItems
     * @param int $nTransports
     * @param \StructType\Transports $transports
     */
    public function __construct($noMoreItems = null, $nTransports = null, \StructType\Transports $transports = null)
    {
        $this
            ->setNoMoreItems($noMoreItems)
            ->setNTransports($nTransports)
            ->setTransports($transports);
    }
    /**
     * Get noMoreItems value
     * @return bool|null
     */
    public function getNoMoreItems()
    {
        return $this->noMoreItems;
    }
    /**
     * Set noMoreItems value
     * @param bool $noMoreItems
     * @return \StructType\ExtractionResult
     */
    public function setNoMoreItems($noMoreItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($noMoreItems) && !is_bool($noMoreItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($noMoreItems)), __LINE__);
        }
        $this->noMoreItems = $noMoreItems;
        return $this;
    }
    /**
     * Get nTransports value
     * @return int|null
     */
    public function getNTransports()
    {
        return $this->nTransports;
    }
    /**
     * Set nTransports value
     * @param int $nTransports
     * @return \StructType\ExtractionResult
     */
    public function setNTransports($nTransports = null)
    {
        // validation for constraint: int
        if (!is_null($nTransports) && !is_numeric($nTransports)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nTransports)), __LINE__);
        }
        $this->nTransports = $nTransports;
        return $this;
    }
    /**
     * Get transports value
     * @return \StructType\Transports|null
     */
    public function getTransports()
    {
        return $this->transports;
    }
    /**
     * Set transports value
     * @param \StructType\Transports $transports
     * @return \StructType\ExtractionResult
     */
    public function setTransports(\StructType\Transports $transports = null)
    {
        $this->transports = $transports;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtractionResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
