<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtractionParameters StructType
 * @subpackage Structs
 */
class ExtractionParameters extends AbstractStructBase
{
    /**
     * The nItems
     * @var int
     */
    public $nItems;
    /**
     * The fullPreviewMode
     * @var bool
     */
    public $fullPreviewMode;
    /**
     * The attachmentFilter
     * @var string
     */
    public $attachmentFilter;
    /**
     * The outputFileMode
     * @var string
     */
    public $outputFileMode;
    /**
     * The includeSubNodes
     * @var bool
     */
    public $includeSubNodes;
    /**
     * The startIndex
     * @var string
     */
    public $startIndex;
    /**
     * Constructor method for ExtractionParameters
     * @uses ExtractionParameters::setNItems()
     * @uses ExtractionParameters::setFullPreviewMode()
     * @uses ExtractionParameters::setAttachmentFilter()
     * @uses ExtractionParameters::setOutputFileMode()
     * @uses ExtractionParameters::setIncludeSubNodes()
     * @uses ExtractionParameters::setStartIndex()
     * @param int $nItems
     * @param bool $fullPreviewMode
     * @param string $attachmentFilter
     * @param string $outputFileMode
     * @param bool $includeSubNodes
     * @param string $startIndex
     */
    public function __construct($nItems = null, $fullPreviewMode = null, $attachmentFilter = null, $outputFileMode = null, $includeSubNodes = null, $startIndex = null)
    {
        $this
            ->setNItems($nItems)
            ->setFullPreviewMode($fullPreviewMode)
            ->setAttachmentFilter($attachmentFilter)
            ->setOutputFileMode($outputFileMode)
            ->setIncludeSubNodes($includeSubNodes)
            ->setStartIndex($startIndex);
    }
    /**
     * Get nItems value
     * @return int|null
     */
    public function getNItems()
    {
        return $this->nItems;
    }
    /**
     * Set nItems value
     * @param int $nItems
     * @return \StructType\ExtractionParameters
     */
    public function setNItems($nItems = null)
    {
        // validation for constraint: int
        if (!is_null($nItems) && !is_numeric($nItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nItems)), __LINE__);
        }
        $this->nItems = $nItems;
        return $this;
    }
    /**
     * Get fullPreviewMode value
     * @return bool|null
     */
    public function getFullPreviewMode()
    {
        return $this->fullPreviewMode;
    }
    /**
     * Set fullPreviewMode value
     * @param bool $fullPreviewMode
     * @return \StructType\ExtractionParameters
     */
    public function setFullPreviewMode($fullPreviewMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($fullPreviewMode) && !is_bool($fullPreviewMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fullPreviewMode)), __LINE__);
        }
        $this->fullPreviewMode = $fullPreviewMode;
        return $this;
    }
    /**
     * Get attachmentFilter value
     * @return string|null
     */
    public function getAttachmentFilter()
    {
        return $this->attachmentFilter;
    }
    /**
     * Set attachmentFilter value
     * @uses \EnumType\ATTACHMENTS_FILTER::valueIsValid()
     * @uses \EnumType\ATTACHMENTS_FILTER::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $attachmentFilter
     * @return \StructType\ExtractionParameters
     */
    public function setAttachmentFilter($attachmentFilter = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ATTACHMENTS_FILTER::valueIsValid($attachmentFilter)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $attachmentFilter, implode(', ', \EnumType\ATTACHMENTS_FILTER::getValidValues())), __LINE__);
        }
        $this->attachmentFilter = $attachmentFilter;
        return $this;
    }
    /**
     * Get outputFileMode value
     * @return string|null
     */
    public function getOutputFileMode()
    {
        return $this->outputFileMode;
    }
    /**
     * Set outputFileMode value
     * @uses \EnumType\WSFILE_MODE::valueIsValid()
     * @uses \EnumType\WSFILE_MODE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outputFileMode
     * @return \StructType\ExtractionParameters
     */
    public function setOutputFileMode($outputFileMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WSFILE_MODE::valueIsValid($outputFileMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $outputFileMode, implode(', ', \EnumType\WSFILE_MODE::getValidValues())), __LINE__);
        }
        $this->outputFileMode = $outputFileMode;
        return $this;
    }
    /**
     * Get includeSubNodes value
     * @return bool|null
     */
    public function getIncludeSubNodes()
    {
        return $this->includeSubNodes;
    }
    /**
     * Set includeSubNodes value
     * @param bool $includeSubNodes
     * @return \StructType\ExtractionParameters
     */
    public function setIncludeSubNodes($includeSubNodes = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSubNodes) && !is_bool($includeSubNodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeSubNodes)), __LINE__);
        }
        $this->includeSubNodes = $includeSubNodes;
        return $this;
    }
    /**
     * Get startIndex value
     * @return string|null
     */
    public function getStartIndex()
    {
        return $this->startIndex;
    }
    /**
     * Set startIndex value
     * @param string $startIndex
     * @return \StructType\ExtractionParameters
     */
    public function setStartIndex($startIndex = null)
    {
        // validation for constraint: string
        if (!is_null($startIndex) && !is_string($startIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startIndex)), __LINE__);
        }
        $this->startIndex = $startIndex;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtractionParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
