<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtractionHeader StructType
 * @subpackage Structs
 */
class ExtractionHeader extends AbstractStructBase
{
    /**
     * The ExtractionJobID
     * @var string
     */
    public $ExtractionJobID;
    /**
     * The ExtractionDocID
     * @var string
     */
    public $ExtractionDocID;
    /**
     * The offset
     * @var int
     */
    public $offset;
    /**
     * The transportIndex
     * @var int
     */
    public $transportIndex;
    /**
     * Constructor method for ExtractionHeader
     * @uses ExtractionHeader::setExtractionJobID()
     * @uses ExtractionHeader::setExtractionDocID()
     * @uses ExtractionHeader::setOffset()
     * @uses ExtractionHeader::setTransportIndex()
     * @param string $extractionJobID
     * @param string $extractionDocID
     * @param int $offset
     * @param int $transportIndex
     */
    public function __construct($extractionJobID = null, $extractionDocID = null, $offset = null, $transportIndex = null)
    {
        $this
            ->setExtractionJobID($extractionJobID)
            ->setExtractionDocID($extractionDocID)
            ->setOffset($offset)
            ->setTransportIndex($transportIndex);
    }
    /**
     * Get ExtractionJobID value
     * @return string|null
     */
    public function getExtractionJobID()
    {
        return $this->ExtractionJobID;
    }
    /**
     * Set ExtractionJobID value
     * @param string $extractionJobID
     * @return \StructType\ExtractionHeader
     */
    public function setExtractionJobID($extractionJobID = null)
    {
        // validation for constraint: string
        if (!is_null($extractionJobID) && !is_string($extractionJobID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extractionJobID)), __LINE__);
        }
        $this->ExtractionJobID = $extractionJobID;
        return $this;
    }
    /**
     * Get ExtractionDocID value
     * @return string|null
     */
    public function getExtractionDocID()
    {
        return $this->ExtractionDocID;
    }
    /**
     * Set ExtractionDocID value
     * @param string $extractionDocID
     * @return \StructType\ExtractionHeader
     */
    public function setExtractionDocID($extractionDocID = null)
    {
        // validation for constraint: string
        if (!is_null($extractionDocID) && !is_string($extractionDocID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extractionDocID)), __LINE__);
        }
        $this->ExtractionDocID = $extractionDocID;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\ExtractionHeader
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Get transportIndex value
     * @return int|null
     */
    public function getTransportIndex()
    {
        return $this->transportIndex;
    }
    /**
     * Set transportIndex value
     * @param int $transportIndex
     * @return \StructType\ExtractionHeader
     */
    public function setTransportIndex($transportIndex = null)
    {
        // validation for constraint: int
        if (!is_null($transportIndex) && !is_numeric($transportIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transportIndex)), __LINE__);
        }
        $this->transportIndex = $transportIndex;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtractionHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
