<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConvertFile StructType
 * @subpackage Structs
 */
class ConvertFile extends AbstractStructBase
{
    /**
     * The inputFile
     * @var \StructType\WSFile
     */
    public $inputFile;
    /**
     * The params
     * @var \StructType\ConversionParameters
     */
    public $params;
    /**
     * Constructor method for ConvertFile
     * @uses ConvertFile::setInputFile()
     * @uses ConvertFile::setParams()
     * @param \StructType\WSFile $inputFile
     * @param \StructType\ConversionParameters $params
     */
    public function __construct(\StructType\WSFile $inputFile = null, \StructType\ConversionParameters $params = null)
    {
        $this
            ->setInputFile($inputFile)
            ->setParams($params);
    }
    /**
     * Get inputFile value
     * @return \StructType\WSFile|null
     */
    public function getInputFile()
    {
        return $this->inputFile;
    }
    /**
     * Set inputFile value
     * @param \StructType\WSFile $inputFile
     * @return \StructType\ConvertFile
     */
    public function setInputFile(\StructType\WSFile $inputFile = null)
    {
        $this->inputFile = $inputFile;
        return $this;
    }
    /**
     * Get params value
     * @return \StructType\ConversionParameters|null
     */
    public function getParams()
    {
        return $this->params;
    }
    /**
     * Set params value
     * @param \StructType\ConversionParameters $params
     * @return \StructType\ConvertFile
     */
    public function setParams(\StructType\ConversionParameters $params = null)
    {
        $this->params = $params;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConvertFile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
