<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessRules StructType
 * @subpackage Structs
 */
class BusinessRules extends AbstractStructBase
{
    /**
     * The configurationName
     * @var string
     */
    public $configurationName;
    /**
     * The ruleName
     * @var string
     */
    public $ruleName;
    /**
     * Constructor method for BusinessRules
     * @uses BusinessRules::setConfigurationName()
     * @uses BusinessRules::setRuleName()
     * @param string $configurationName
     * @param string $ruleName
     */
    public function __construct($configurationName = null, $ruleName = null)
    {
        $this
            ->setConfigurationName($configurationName)
            ->setRuleName($ruleName);
    }
    /**
     * Get configurationName value
     * @return string|null
     */
    public function getConfigurationName()
    {
        return $this->configurationName;
    }
    /**
     * Set configurationName value
     * @param string $configurationName
     * @return \StructType\BusinessRules
     */
    public function setConfigurationName($configurationName = null)
    {
        // validation for constraint: string
        if (!is_null($configurationName) && !is_string($configurationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($configurationName)), __LINE__);
        }
        $this->configurationName = $configurationName;
        return $this;
    }
    /**
     * Get ruleName value
     * @return string|null
     */
    public function getRuleName()
    {
        return $this->ruleName;
    }
    /**
     * Set ruleName value
     * @param string $ruleName
     * @return \StructType\BusinessRules
     */
    public function setRuleName($ruleName = null)
    {
        // validation for constraint: string
        if (!is_null($ruleName) && !is_string($ruleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ruleName)), __LINE__);
        }
        $this->ruleName = $ruleName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
